/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;
import org.infinispan.query.remote.impl.logging.Log;

public final class ProtobufValueWrapperFieldBridge
implements FieldBridge {
    private static final Log log = (Log)LogFactory.getLog(ProtobufValueWrapperFieldBridge.class, Log.class);
    private final Cache cache;
    private SerializationContext serializationContext = null;
    private Descriptor wrapperDescriptor = null;

    public ProtobufValueWrapperFieldBridge(Cache cache) {
        this.cache = cache;
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (!(value instanceof ProtobufValueWrapper)) {
            throw new IllegalArgumentException("This FieldBridge can only be applied to a " + ProtobufValueWrapper.class.getName());
        }
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)value;
        if (log.isDebugEnabled()) {
            log.debugf("Setting Lucene document properties for %s in cache %s", valueWrapper.toString(), this.cache.getName());
        }
        this.decodeAndIndex(valueWrapper, document, luceneOptions);
    }

    private void decodeAndIndex(ProtobufValueWrapper valueWrapper, Document document, LuceneOptions luceneOptions) {
        if (this.serializationContext == null) {
            this.serializationContext = ProtobufMetadataManagerImpl.getSerializationContextInternal(this.cache.getCacheManager());
        }
        if (this.wrapperDescriptor == null) {
            this.wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        }
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new WrappedMessageTagHandler(valueWrapper, document, luceneOptions, this.serializationContext), this.wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

