/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.server.core.dataconversion.JBossMarshallingTranscoder;
import org.infinispan.server.core.dataconversion.JavaSerializationTranscoder;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.ProtostreamBinaryTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;

@InfinispanModule(name="server-core", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        ClassWhiteList classWhiteList = ((EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class)).getClassWhiteList();
        ClassLoader classLoader = globalConfiguration.classLoader();
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller(classLoader, classWhiteList);
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        JsonTranscoder jsonTranscoder = new JsonTranscoder(classLoader, classWhiteList);
        encoderRegistry.registerTranscoder((Transcoder)jsonTranscoder);
        encoderRegistry.registerTranscoder((Transcoder)new JBossMarshallingTranscoder(jsonTranscoder, marshaller));
        encoderRegistry.registerTranscoder((Transcoder)new XMLTranscoder(classLoader, classWhiteList));
        encoderRegistry.registerTranscoder((Transcoder)new JavaSerializationTranscoder(classWhiteList));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamBinaryTranscoder());
    }
}

