/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLTranscoder
extends OneToManyTranscoder {
    private static final Log logger = (Log)LogFactory.getLog(XMLTranscoder.class, Log.class);
    private static final SAXParserFactory SAXFACTORY = SAXParserFactory.newInstance();

    public XMLTranscoder() {
        this(XMLTranscoder.class.getClassLoader(), new ClassWhiteList(Collections.emptyList()));
    }

    public XMLTranscoder(ClassWhiteList classWhiteList) {
        this(XMLTranscoder.class.getClassLoader(), classWhiteList);
    }

    public XMLTranscoder(ClassLoader classLoader, ClassWhiteList whiteList) {
        super(MediaType.APPLICATION_XML, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN});
        XStreamHolder.XStream.addPermission(NoTypePermission.NONE);
        XStreamHolder.XStream.addPermission(type -> whiteList.isSafeClass(type.getName()));
        XStreamHolder.XStream.setClassLoader(classLoader);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                Object decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
                String xmlString = XStreamHolder.XStream.toXML(decoded);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = XStreamHolder.XStream.toXML((Object)inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM) || contentType.match(MediaType.APPLICATION_UNKNOWN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = XStreamHolder.XStream.toXML((Object)inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM) || destinationType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertCharset((Object)content, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                Reader xmlReader = content instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                return XStreamHolder.XStream.fromXML(xmlReader);
            }
            catch (ForbiddenClassException e) {
                throw logger.errorDeserializing(e.getMessage());
            }
            catch (XStreamException e) {
                throw new CacheException((Throwable)e);
            }
        }
        throw logger.unsupportedDataFormat(contentType);
    }

    private boolean isWellFormed(byte[] content) {
        try {
            XMLReader xmlReader = SAXFACTORY.newSAXParser().getXMLReader();
            xmlReader.parse(new InputSource(new ByteArrayInputStream(content)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }

    private static class XStreamHolder {
        static final XStream XStream = new XStream((HierarchicalStreamDriver)new StaxDriver());

        private XStreamHolder() {
        }
    }
}

