/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.group.ChannelGroup;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;

class NettyTransportConnectionStats {
    private final EmbeddedCacheManager cacheManager;
    private final boolean isGlobalStatsEnabled;
    private final ChannelGroup acceptedChannels;
    private final String threadNamePrefix;
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalBytesRead = new AtomicLong();

    public NettyTransportConnectionStats(EmbeddedCacheManager cacheManager, ChannelGroup acceptedChannels, String threadNamePrefix) {
        this.cacheManager = cacheManager;
        this.isGlobalStatsEnabled = cacheManager != null && cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled();
        this.acceptedChannels = acceptedChannels;
        this.threadNamePrefix = threadNamePrefix;
    }

    private void increment(AtomicLong base, long bytes) {
        if (this.isGlobalStatsEnabled) {
            base.addAndGet(bytes);
        }
    }

    public void incrementTotalBytesWritten(long bytes) {
        this.increment(this.totalBytesWritten, bytes);
    }

    public void incrementTotalBytesRead(long bytes) {
        this.increment(this.totalBytesRead, bytes);
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    private boolean needDistributedCalculation() {
        if (this.cacheManager != null) {
            return this.cacheManager.getMembers() != null && this.cacheManager.getMembers().size() > 1;
        }
        return false;
    }

    private int calculateGlobalConnections() {
        AtomicInteger connectionCount = new AtomicInteger();
        CompletableFuture results = this.cacheManager.executor().submitConsumer((Function)new ConnectionAdderTask(this.threadNamePrefix), (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            connectionCount.addAndGet((int)v);
        });
        try {
            results.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
        return connectionCount.get();
    }

    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels.size();
    }

    public Integer getNumberOfGlobalConnections() {
        if (this.needDistributedCalculation()) {
            return this.calculateGlobalConnections();
        }
        return this.getNumberOfLocalConnections();
    }

    static class ConnectionAdderTask
    implements Serializable,
    Function<EmbeddedCacheManager, Integer> {
        private final String serverName;

        ConnectionAdderTask(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public Integer apply(EmbeddedCacheManager embeddedCacheManager) {
            GlobalJmxStatisticsConfiguration globalCfg = embeddedCacheManager.getCacheManagerConfiguration().globalJmxStatistics();
            String jmxDomain = globalCfg.domain();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)globalCfg.mbeanServerLookup(), (Properties)globalCfg.properties());
            try {
                ObjectName transportMBeanName = new ObjectName(jmxDomain + ":type=Server,component=Transport,name=" + this.serverName);
                return (Integer)mbeanServer.getAttribute(transportMBeanName, "NumberOfLocalConnections");
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

