/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.server.core.admin.AdminServerTask;

public class TemplateCreateTask
extends AdminServerTask<Void> {
    private static final Set<String> PARAMETERS;

    @Override
    public String getTaskContextName() {
        return "template";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String name = this.requireParameter(parameters, "name");
        String configuration = this.requireParameter(parameters, "configuration");
        Configuration config = this.getConfiguration(name, configuration);
        if (!cacheManager.getCacheManagerConfiguration().isClustered() && config.clustering().cacheMode().isClustered()) {
            throw log.cannotCreateClusteredCache();
        }
        ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createTemplate(name, config);
        return null;
    }

    protected Configuration getConfiguration(String name, String configuration) {
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(configuration);
        if (!builderHolder.getNamedConfigurationBuilders().containsKey(name)) {
            throw log.missingCacheConfiguration(name, configuration);
        }
        return ((ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().get(name)).build();
    }

    static {
        HashSet<String> params = new HashSet<String>(2);
        params.add("name");
        params.add("configuration");
        PARAMETERS = Collections.unmodifiableSet(params);
    }
}

