/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.impl.AuthorizationHelper;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static GlobalConfiguration getGlobalConfiguration(EmbeddedCacheManager cacheManager) {
        GetCacheManagerConfigurationAction action = new GetCacheManagerConfigurationAction(cacheManager);
        return (GlobalConfiguration)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        AuthorizationHelper authzHelper = (AuthorizationHelper)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(AuthorizationHelper.class);
        authzHelper.checkPermission(cacheManager.getSubject(), permission);
    }
}

