/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.dataconversion.TranscodingException;
import org.infinispan.server.core.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String channelStillBound = "ISPN005005: %s is still bound to %s";
    private static final String channelStillConnected = "ISPN005007: %s is still connected to %s";
    private static final String illegalWorkerThreads = "ISPN005010: Illegal number of workerThreads: %d";
    private static final String illegalIdleTimeout = "ISPN005011: Idle timeout can't be lower than -1: %d";
    private static final String illegalReceiveBufferSize = "ISPN005012: Receive Buffer Size can't be lower than 0: %d";
    private static final String illegalSendBufferSize = "ISPN005013: Send Buffer Size can't be lower than 0: %d";
    private static final String noSSLKeyManagerConfiguration = "ISPN005014: SSL Enabled but no KeyStore specified";
    private static final String missingKeyStorePassword = "ISPN005016: A password is required to open the KeyStore '%s'";
    private static final String missingTrustStorePassword = "ISPN005017: A password is required to open the TrustStore '%s'";
    private static final String xorSSLContext = "ISPN005018: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    private static final String createdSocketChannel = "ISPN005025: Using Netty SocketChannel %s for %s";
    private static final String createdNettyEventLoop = "ISPN005026: Using Netty EventLoop %s for %s";
    private static final String noSniDomainConfigured = "ISPN005027: SSL Enabled but no SNI domain configured";
    private static final String epollNotAvailable = "ISPN005028: Native Epoll transport not available, using NIO instead: %s";
    private static final String cannotRegisterAdminOperationsHandler = "ISPN005029: No task manager available to register the admin operations handler";
    private static final String missingRequiredAdminTaskParameter = "ISPN005030: Administration task '%s' invoked without required parameter '%s'";
    private static final String missingCacheConfiguration = "ISPN005031: The supplied configuration for cache '%s' is missing a named configuration for it: %s";
    private static final String unsupportedDataFormat = "ISPN005033: Data format '%s' not supported";
    private static final String cannotCreateClusteredCache = "ISPN005034: Cannot create clustered caches in non-clustered servers";
    private static final String errorDeserializing = "ISPN005035: Class '%s' blocked by deserialization allow list. Include the class name in the server cache manager allow list to authorize.";
    private static final String illegalIOThreads = "ISPN005036: Illegal number of ioThreads: %d";
    private static final String illegalParameterType = "ISPN005038: Illegal type for parameter '%s': %s";
    private static final String errorCreatingBackup = "ISPN005039: Cannot create cluster backup";
    private static final String errorRestoringBackup = "ISPN005040: Cannot restore cluster backup '%s'";
    private static final String backupInProgress = "ISPN005041: Cannot perform backup, backup currently in progress";
    private static final String restoreInProgress = "ISPN005042: Cannot restore content, restore currently in progress";
    private static final String initiatingBackup = "ISPN005043: Starting backup '%s'";
    private static final String backupComplete = "ISPN005044: Backup file created '%s'";
    private static final String initiatingRestore = "ISPN005045: Starting restore '%s' of '%s'";
    private static final String restoreComplete = "ISPN005046: Restore '%s' complete";
    private static final String unableToFindBackupResource = "ISPN005047: %s '%s' not found in the backup archive";
    private static final String unableToFindResource = "ISPN005048: %s '%s' does not exist";
    private static final String backupAlreadyExists = "ISPN005049: Cannot perform backup, backup already exists with name '%s'";
    private static final String backupDeleted = "ISPN005050: Deleted backup '%s'";
    private static final String restoreAlreadyExists = "ISPN005051: Cannot perform restore, restore already exists with name '%s'";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void channelStillBound(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillBound$str(), (Object)ch, (Object)address);
    }

    protected String channelStillBound$str() {
        return channelStillBound;
    }

    @Override
    public final void channelStillConnected(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillConnected$str(), (Object)ch, (Object)address);
    }

    protected String channelStillConnected$str() {
        return channelStillConnected;
    }

    protected String illegalWorkerThreads$str() {
        return illegalWorkerThreads;
    }

    @Override
    public final IllegalArgumentException illegalWorkerThreads(int workerThreads) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalWorkerThreads$str(), workerThreads));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalIdleTimeout$str() {
        return illegalIdleTimeout;
    }

    @Override
    public final IllegalArgumentException illegalIdleTimeout(int idleTimeout) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalIdleTimeout$str(), idleTimeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalReceiveBufferSize$str() {
        return illegalReceiveBufferSize;
    }

    @Override
    public final IllegalArgumentException illegalReceiveBufferSize(int recvBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalReceiveBufferSize$str(), recvBufSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalSendBufferSize$str() {
        return illegalSendBufferSize;
    }

    @Override
    public final IllegalArgumentException illegalSendBufferSize(int sendBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalSendBufferSize$str(), sendBufSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSSLKeyManagerConfiguration$str() {
        return noSSLKeyManagerConfiguration;
    }

    @Override
    public final CacheConfigurationException noSSLKeyManagerConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSSLKeyManagerConfiguration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingKeyStorePassword$str() {
        return missingKeyStorePassword;
    }

    @Override
    public final CacheConfigurationException missingKeyStorePassword(String keyStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingKeyStorePassword$str(), keyStore));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingTrustStorePassword$str() {
        return missingTrustStorePassword;
    }

    @Override
    public final CacheConfigurationException missingTrustStorePassword(String trustStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingTrustStorePassword$str(), trustStore));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String xorSSLContext$str() {
        return xorSSLContext;
    }

    @Override
    public final CacheConfigurationException xorSSLContext() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xorSSLContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void createdSocketChannel(String channelClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdSocketChannel$str(), (Object)channelClassName, (Object)configuration);
    }

    protected String createdSocketChannel$str() {
        return createdSocketChannel;
    }

    @Override
    public final void createdNettyEventLoop(String eventLoopClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdNettyEventLoop$str(), (Object)eventLoopClassName, (Object)configuration);
    }

    protected String createdNettyEventLoop$str() {
        return createdNettyEventLoop;
    }

    protected String noSniDomainConfigured$str() {
        return noSniDomainConfigured;
    }

    @Override
    public final CacheConfigurationException noSniDomainConfigured() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSniDomainConfigured$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void epollNotAvailable(String message) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.epollNotAvailable$str(), (Object)message);
    }

    protected String epollNotAvailable$str() {
        return epollNotAvailable;
    }

    protected String cannotRegisterAdminOperationsHandler$str() {
        return cannotRegisterAdminOperationsHandler;
    }

    @Override
    public final CacheConfigurationException cannotRegisterAdminOperationsHandler() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotRegisterAdminOperationsHandler$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingRequiredAdminTaskParameter$str() {
        return missingRequiredAdminTaskParameter;
    }

    @Override
    public final NullPointerException missingRequiredAdminTaskParameter(String name, String parameter) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.missingRequiredAdminTaskParameter$str(), name, parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCacheConfiguration$str() {
        return missingCacheConfiguration;
    }

    @Override
    public final CacheConfigurationException missingCacheConfiguration(String name, String configuration) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingCacheConfiguration$str(), name, configuration));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }

    @Override
    public final TranscodingException unsupportedDataFormat(MediaType contentFormat) {
        TranscodingException result = new TranscodingException(String.format(this.getLoggingLocale(), this.unsupportedDataFormat$str(), contentFormat));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateClusteredCache$str() {
        return cannotCreateClusteredCache;
    }

    @Override
    public final UnsupportedOperationException cannotCreateClusteredCache() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotCreateClusteredCache$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorDeserializing$str() {
        return errorDeserializing;
    }

    @Override
    public final CacheException errorDeserializing(String className) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorDeserializing$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalIOThreads$str() {
        return illegalIOThreads;
    }

    @Override
    public final IllegalArgumentException illegalIOThreads(int ioThreads) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalIOThreads$str(), ioThreads));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalParameterType$str() {
        return illegalParameterType;
    }

    @Override
    public final IllegalArgumentException illegalParameterType(String parameter, Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalParameterType$str(), parameter, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingBackup$str() {
        return errorCreatingBackup;
    }

    @Override
    public final CacheException errorCreatingBackup(Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorCreatingBackup$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorRestoringBackup$str() {
        return errorRestoringBackup;
    }

    @Override
    public final CacheException errorRestoringBackup(Path path, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorRestoringBackup$str(), path), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupInProgress$str() {
        return backupInProgress;
    }

    @Override
    public final CacheException backupInProgress() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.backupInProgress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String restoreInProgress$str() {
        return restoreInProgress;
    }

    @Override
    public final CacheException restoreInProgress() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.restoreInProgress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void initiatingBackup(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initiatingBackup$str(), (Object)name);
    }

    protected String initiatingBackup$str() {
        return initiatingBackup;
    }

    @Override
    public final void backupComplete(String backupName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.backupComplete$str(), (Object)backupName);
    }

    protected String backupComplete$str() {
        return backupComplete;
    }

    @Override
    public final void initiatingRestore(String name, Path backup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initiatingRestore$str(), (Object)name, (Object)backup);
    }

    protected String initiatingRestore$str() {
        return initiatingRestore;
    }

    @Override
    public final void restoreComplete(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.restoreComplete$str(), (Object)name);
    }

    protected String restoreComplete$str() {
        return restoreComplete;
    }

    protected String unableToFindBackupResource$str() {
        return unableToFindBackupResource;
    }

    @Override
    public final CacheException unableToFindBackupResource(String resource, Set<String> resourceNames) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToFindBackupResource$str(), resource, resourceNames));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFindResource$str() {
        return unableToFindResource;
    }

    @Override
    public final CacheException unableToFindResource(String resource, String resourceName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToFindResource$str(), resource, resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupAlreadyExists$str() {
        return backupAlreadyExists;
    }

    @Override
    public final CacheException backupAlreadyExists(String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.backupAlreadyExists$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void backupDeleted(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.backupDeleted$str(), (Object)name);
    }

    protected String backupDeleted$str() {
        return backupDeleted;
    }

    protected String restoreAlreadyExists$str() {
        return restoreAlreadyExists;
    }

    @Override
    public final CacheException restoreAlreadyExists(String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.restoreAlreadyExists$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

