/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.PublisherTransformers;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.resources.AbstractContainerResource;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.reactivestreams.Publisher;

public class CacheResource
extends AbstractContainerResource {
    private final EmbeddedCacheManager cm;
    private final ParserRegistry parserRegistry;

    CacheResource(BlockingManager blockingManager, ParserRegistry parserRegistry, EmbeddedCacheManager cm, BackupManager.Resources params, Path root) {
        super(BackupManager.Resources.Type.CACHES, params, blockingManager, root);
        this.cm = cm;
        this.parserRegistry = parserRegistry;
    }

    @Override
    public void prepareAndValidateBackup() {
        InternalCacheRegistry icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cm).getComponent(InternalCacheRegistry.class);
        Set caches = this.wildcard ? this.cm.getCacheConfigurationNames() : this.resources;
        for (String cache : caches) {
            Configuration config = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cm, (String)cache);
            if (this.wildcard) {
                if (config == null || config.isTemplate() || icr.isInternalCache(cache) || CacheResource.isInternalName(cache)) continue;
                this.resources.add(cache);
                continue;
            }
            if (config == null) {
                throw log.unableToFindResource(this.type.toString(), cache);
            }
            if (!config.isTemplate()) continue;
            throw new CacheException(String.format("Unable to backup %s '%s' as it is a template not a cache", new Object[]{this.type, cache}));
        }
    }

    @Override
    public CompletionStage<Void> backup() {
        AggregateCompletionStage stages = CompletionStages.aggregateCompletionStage();
        for (String cache : this.resources) {
            stages.dependsOn(this.createCacheBackup(cache));
        }
        return stages.freeze();
    }

    @Override
    public CompletionStage<Void> restore(ZipFile zip) {
        GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cm);
        ConfigurationManager configurationManager = (ConfigurationManager)gcr.getComponent(ConfigurationManager.class);
        NonBlockingManager nbm = (NonBlockingManager)gcr.getComponent(NonBlockingManager.class);
        Properties properties = new Properties();
        properties.put("org.infinispan.parser.ignoreDuplicates", (Object)true);
        return CompletionStages.performConcurrently((Iterable)this.resources, (int)ProcessorInfo.availableProcessors(), (Scheduler)nbm.asScheduler(), cacheName -> {
            if (log.isDebugEnabled()) {
                log.debugf("Start recover for '%s' at %s", cacheName, System.currentTimeMillis());
            }
            CompletionStage<Void> cs = this.recoverCache((String)cacheName, properties, configurationManager, zip);
            if (log.isDebugEnabled()) {
                return cs.whenComplete((ignore, t) -> log.debugf("Finished recover for '%s' at %d", cacheName, System.currentTimeMillis()));
            }
            return cs;
        });
    }

    private CompletionStage<Void> recoverCache(String cacheName, Properties properties, ConfigurationManager configurationManager, ZipFile zip) {
        return this.createCache(cacheName, properties, configurationManager, zip).thenCompose(ignore -> this.restoreCacheContents(cacheName, zip));
    }

    private CompletionStage<Void> createCache(String cacheName, Properties properties, ConfigurationManager configurationManager, ZipFile zip) {
        return this.blockingManager.runBlocking(() -> {
            Path cacheRoot = this.root.resolve(cacheName);
            String configFile = this.configFile(cacheName);
            String zipPath = cacheRoot.resolve(configFile).toString();
            try (InputStream is = zip.getInputStream(zip.getEntry(zipPath));){
                ConfigurationReader reader = ConfigurationReader.from((InputStream)is).withProperties(properties).withNamingStrategy(NamingStrategy.KEBAB_CASE).withType(MediaType.fromExtension((String)configFile)).build();
                ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(reader, configurationManager.toBuilderHolder());
                Configuration config = ((ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().get(cacheName)).build();
                log.debugf("Restoring Cache %s: %s", cacheName, config.toStringConfiguration(cacheName));
                SecurityActions.getOrCreateCache((EmbeddedCacheManager)this.cm, (String)cacheName, (Configuration)config);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }, (Object)("create-cache-" + cacheName));
    }

    private CompletionStage<Void> restoreCacheContents(final String cacheName, ZipFile zip) {
        Flowable f = Flowable.using(() -> {
            String dataFile;
            Path cacheRoot = this.root.resolve(cacheName);
            String data = cacheRoot.resolve(dataFile = this.dataFile(cacheName)).toString();
            ZipEntry zipEntry = zip.getEntry(data);
            if (zipEntry == null) {
                return null;
            }
            return new DataInputStream(zip.getInputStream(zipEntry));
        }, is -> {
            if (is == null) {
                return Flowable.empty();
            }
            SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cm).getComponent(SerializationContextRegistry.class);
            final ImmutableSerializationContext serCtx = ctxRegistry.getPersistenceCtx();
            Iterator<CacheBackupEntry> backupEntries = new Iterator<CacheBackupEntry>(this){
                final /* synthetic */ CacheResource this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    try {
                        return is.available() > 0;
                    }
                    catch (IOException e) {
                        AbstractContainerResource.log.errorf("Failed checking data available to recover %s", cacheName, e);
                        return false;
                    }
                }

                @Override
                public CacheBackupEntry next() {
                    try {
                        return AbstractContainerResource.readMessageStream(serCtx, CacheBackupEntry.class, is);
                    }
                    catch (IOException e) {
                        AbstractContainerResource.log.errorf("Failed reading entry to recover %s", cacheName, e);
                        throw new CacheException((Throwable)e);
                    }
                }
            };
            return Flowable.fromIterable(() -> backupEntries);
        }, is -> {
            if (is != null) {
                is.close();
            }
        });
        if (!this.cm.isRunning(cacheName)) {
            throw new IllegalStateException("Cache " + cacheName + " is not defined");
        }
        AdvancedCache cache = this.cm.getCache(cacheName).getAdvancedCache();
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry((AdvancedCache)cache);
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        KeyPartitioner keyPartitioner = (KeyPartitioner)cr.getComponent(KeyPartitioner.class);
        InvocationHelper invocationHelper = (InvocationHelper)cr.getComponent(InvocationHelper.class);
        StorageConfigurationManager scm = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
        PersistenceMarshaller persistenceMarshaller = cr.getPersistenceMarshaller();
        Marshaller userMarshaller = persistenceMarshaller.getUserMarshaller();
        boolean keyMarshalling = !scm.getKeyStorageMediaType().isBinary();
        boolean valueMarshalling = !scm.getValueStorageMediaType().isBinary();
        int batchSize = SecurityActions.getCacheConfiguration((AdvancedCache)cache).clustering().stateTransfer().chunkSize();
        Flowable p = f.rebatchRequests(batchSize).map(entry -> {
            Object key = keyMarshalling ? CacheResource.unmarshall(entry.key, userMarshaller) : scm.getKeyWrapper().wrap((Object)entry.key);
            Object value = valueMarshalling ? CacheResource.unmarshall(entry.value, userMarshaller) : scm.getValueWrapper().wrap((Object)entry.value);
            Metadata metadata = (Metadata)CacheResource.unmarshall(entry.metadata, (Marshaller)persistenceMarshaller);
            InternalMetadataImpl internalMetadataImpl = new InternalMetadataImpl(metadata, entry.created, entry.lastUsed);
            PutKeyValueCommand cmd = commandsFactory.buildPutKeyValueCommand(key, value, keyPartitioner.getSegment(key), (Metadata)internalMetadataImpl, FlagBitSets.IGNORE_RETURN_VALUES);
            commandsFactory.buildPutKeyValueCommand(key, value, keyPartitioner.getSegment(key), (Metadata)internalMetadataImpl, FlagBitSets.IGNORE_RETURN_VALUES);
            cmd.setInternalMetadata(entry.internalMetadata);
            return cmd;
        }).flatMap(cmd -> RxJavaInterop.voidCompletionStageToFlowable((CompletionStage)invocationHelper.invokeAsync((VisitableCommand)cmd, 1)));
        return Flowable.fromPublisher((Publisher)this.blockingManager.blockingPublisher((Publisher)p)).count().toCompletionStage().thenAccept(entries -> log.debugf("Cache %s restored %d entries", cacheName, entries));
    }

    private CompletionStage<Void> createCacheBackup(String cacheName) {
        return this.blockingManager.supplyBlocking(() -> {
            DataOutputStream output;
            AdvancedCache cache = this.cm.getCache(cacheName).getAdvancedCache();
            Configuration configuration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cm, (String)cacheName);
            Path cacheRoot = this.root.resolve(cacheName);
            this.mkdirs(cacheRoot);
            String xmlFileName = this.configFile(cacheName);
            Path xmlPath = cacheRoot.resolve(xmlFileName);
            try (OutputStream os = Files.newOutputStream(xmlPath, new OpenOption[0]);){
                this.parserRegistry.serialize(os, cacheName, configuration);
            }
            catch (IOException e2) {
                throw new CacheException(String.format("Unable to create backup file '%s'", xmlFileName), (Throwable)e2);
            }
            ComponentRegistry cr = SecurityActions.getCacheComponentRegistry((AdvancedCache)cache);
            ClusterPublisherManager clusterPublisherManager = (ClusterPublisherManager)cr.getClusterPublisherManager().running();
            SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)cr.getGlobalComponentRegistry().getComponent(SerializationContextRegistry.class);
            ImmutableSerializationContext serCtx = ctxRegistry.getPersistenceCtx();
            String dataFileName = this.dataFile(cacheName);
            Path datFile = cacheRoot.resolve(dataFileName);
            StorageConfigurationManager scm = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
            boolean keyMarshalling = !scm.getKeyStorageMediaType().isBinary();
            boolean valueMarshalling = !scm.getValueStorageMediaType().isBinary();
            PersistenceMarshaller persistenceMarshaller = cr.getPersistenceMarshaller();
            Marshaller userMarshaller = persistenceMarshaller.getUserMarshaller();
            if (log.isDebugEnabled()) {
                log.debugf("Backing up Cache %s", configuration.toStringConfiguration(cacheName));
            }
            int bufferSize = configuration.clustering().stateTransfer().chunkSize();
            Flowable p = Flowable.fromPublisher((Publisher)clusterPublisherManager.entryPublisher(null, null, null, 0L, DeliveryGuarantee.EXACTLY_ONCE, bufferSize, PublisherTransformers.identity()).publisherWithoutSegments()).map(e -> {
                CacheBackupEntry be = new CacheBackupEntry();
                boolean multimapMetadata = e.getMetadata() instanceof MetaParamsInternalMetadata;
                byte[] byArray = be.key = keyMarshalling ? this.marshall(e.getKey(), userMarshaller) : (byte[])scm.getKeyWrapper().unwrap(e.getKey());
                be.value = valueMarshalling ? this.marshall(e.getValue(), userMarshaller) : (multimapMetadata ? this.marshall(e.getValue(), (Marshaller)persistenceMarshaller) : (byte[])scm.getValueWrapper().unwrap(e.getValue()));
                be.metadata = this.marshall(e.getMetadata(), (Marshaller)persistenceMarshaller);
                be.internalMetadata = e.getInternalMetadata();
                be.created = e.getCreated();
                be.lastUsed = e.getLastUsed();
                return be;
            });
            try {
                output = new DataOutputStream(Files.newOutputStream(datFile, new OpenOption[0]));
            }
            catch (IOException e3) {
                throw Util.rewrapAsCacheException((Throwable)e3);
            }
            AtomicInteger entries = new AtomicInteger();
            CompletionStage stage = this.blockingManager.subscribeBlockingConsumer((Publisher)p, backup -> {
                entries.incrementAndGet();
                try {
                    CacheResource.writeMessageStream(backup, serCtx, output);
                }
                catch (IOException ex) {
                    throw Util.rewrapAsCacheException((Throwable)ex);
                }
            }, (Object)"backup-cache-entries");
            return stage.whenComplete((Void2, t) -> {
                if (t == null) {
                    log.debugf("Cache %s backed up %d entries", cacheName, entries.get());
                }
                Util.close((AutoCloseable)output);
            });
        }, (Object)"backup-cache").thenCompose(Function.identity());
    }

    private String configFile(String cache) {
        return String.format("%s.xml", cache);
    }

    private String dataFile(String cache) {
        return String.format("%s.dat", cache);
    }

    private byte[] marshall(Object key, Marshaller marshaller) {
        try {
            return marshaller.objectToByteBuffer(key);
        }
        catch (IOException | InterruptedException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    private static <T> T unmarshall(byte[] bytes, Marshaller marshaller) {
        try {
            return (T)marshaller.objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    @ProtoTypeId(value=5401)
    public static class CacheBackupEntry {
        @ProtoField(number=1)
        byte[] key;
        @ProtoField(number=2)
        byte[] value;
        @ProtoField(number=3)
        byte[] metadata;
        @ProtoField(number=4)
        PrivateMetadata internalMetadata;
        @ProtoField(number=5, defaultValue="-1")
        long created;
        @ProtoField(number=6, defaultValue="-1")
        long lastUsed;
    }
}

