/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.lang.reflect.Constructor;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ShutdownHook;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.jboss.netty.channel.Channel;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class Main$
implements Log {
    public static final Main$ MODULE$;
    private final String PROP_KEY_PORT;
    private final String PROP_KEY_HOST;
    private final String PROP_KEY_MASTER_THREADS;
    private final String PROP_KEY_WORKER_THREADS;
    private final String PROP_KEY_CACHE_CONFIG;
    private final String PROP_KEY_PROTOCOL;
    private final String PROP_KEY_IDLE_TIMEOUT;
    private final String PROP_KEY_TCP_NO_DELAY;
    private final String PROP_KEY_SEND_BUF_SIZE;
    private final String PROP_KEY_RECV_BUF_SIZE;
    private final String PROP_KEY_PROXY_HOST;
    private final String PROP_KEY_PROXY_PORT;
    private final String PROP_KEY_TOPOLOGY_LOCK_TIMEOUT;
    private final String PROP_KEY_TOPOLOGY_REPL_TIMEOUT;
    private final String PROP_KEY_TOPOLOGY_STATE_TRANSFER;
    private final String PROP_KEY_TOPOLOGY_UPDATE_TIMEOUT;
    private final String PROP_KEY_CACHE_MANAGER_CLASS;
    private final String HOST_DEFAULT;
    private final int WORKER_THREADS_DEFAULT;
    private final int IDLE_TIMEOUT_DEFAULT;
    private final boolean TCP_NO_DELAY_DEFAULT;
    private final int SEND_BUF_SIZE_DEFAULT;
    private final int RECV_BUF_SIZE_DEFAULT;
    private final long TOPO_LOCK_TIMEOUT_DEFAULT;
    private final long TOPO_REPL_TIMEOUT_DEFAULT;
    private final long TOPO_UPDATE_TIMEOUT_DEFAULT;
    private final boolean TOPO_STATE_TRANSFER_DEFAULT;
    private final Properties props;
    private ProtocolServer server;
    private EmbeddedCacheManager cacheManager;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile boolean bitmap$0;

    static {
        new Main$();
    }

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!this.bitmap$0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return this.bitmap$0 ? this.org$infinispan$server$core$logging$Log$$log : this.org$infinispan$server$core$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Log$class.error(this, msg, t);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Log$class.warn(this, msg, t);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg) {
        Log$class.debug((Log)this, t, msg);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log$class.tracef(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    @Override
    public void logErrorBeforeReadingRequest(Throwable t) {
        Log$class.logErrorBeforeReadingRequest(this, t);
    }

    public String PROP_KEY_PORT() {
        return this.PROP_KEY_PORT;
    }

    public String PROP_KEY_HOST() {
        return this.PROP_KEY_HOST;
    }

    public String PROP_KEY_MASTER_THREADS() {
        return this.PROP_KEY_MASTER_THREADS;
    }

    public String PROP_KEY_WORKER_THREADS() {
        return this.PROP_KEY_WORKER_THREADS;
    }

    public String PROP_KEY_CACHE_CONFIG() {
        return this.PROP_KEY_CACHE_CONFIG;
    }

    public String PROP_KEY_PROTOCOL() {
        return this.PROP_KEY_PROTOCOL;
    }

    public String PROP_KEY_IDLE_TIMEOUT() {
        return this.PROP_KEY_IDLE_TIMEOUT;
    }

    public String PROP_KEY_TCP_NO_DELAY() {
        return this.PROP_KEY_TCP_NO_DELAY;
    }

    public String PROP_KEY_SEND_BUF_SIZE() {
        return this.PROP_KEY_SEND_BUF_SIZE;
    }

    public String PROP_KEY_RECV_BUF_SIZE() {
        return this.PROP_KEY_RECV_BUF_SIZE;
    }

    public String PROP_KEY_PROXY_HOST() {
        return this.PROP_KEY_PROXY_HOST;
    }

    public String PROP_KEY_PROXY_PORT() {
        return this.PROP_KEY_PROXY_PORT;
    }

    public String PROP_KEY_TOPOLOGY_LOCK_TIMEOUT() {
        return this.PROP_KEY_TOPOLOGY_LOCK_TIMEOUT;
    }

    public String PROP_KEY_TOPOLOGY_REPL_TIMEOUT() {
        return this.PROP_KEY_TOPOLOGY_REPL_TIMEOUT;
    }

    public String PROP_KEY_TOPOLOGY_STATE_TRANSFER() {
        return this.PROP_KEY_TOPOLOGY_STATE_TRANSFER;
    }

    public String PROP_KEY_TOPOLOGY_UPDATE_TIMEOUT() {
        return this.PROP_KEY_TOPOLOGY_UPDATE_TIMEOUT;
    }

    public String PROP_KEY_CACHE_MANAGER_CLASS() {
        return this.PROP_KEY_CACHE_MANAGER_CLASS;
    }

    public String HOST_DEFAULT() {
        return this.HOST_DEFAULT;
    }

    public int WORKER_THREADS_DEFAULT() {
        return this.WORKER_THREADS_DEFAULT;
    }

    public int IDLE_TIMEOUT_DEFAULT() {
        return this.IDLE_TIMEOUT_DEFAULT;
    }

    public boolean TCP_NO_DELAY_DEFAULT() {
        return this.TCP_NO_DELAY_DEFAULT;
    }

    public int SEND_BUF_SIZE_DEFAULT() {
        return this.SEND_BUF_SIZE_DEFAULT;
    }

    public int RECV_BUF_SIZE_DEFAULT() {
        return this.RECV_BUF_SIZE_DEFAULT;
    }

    public long TOPO_LOCK_TIMEOUT_DEFAULT() {
        return this.TOPO_LOCK_TIMEOUT_DEFAULT;
    }

    public long TOPO_REPL_TIMEOUT_DEFAULT() {
        return this.TOPO_REPL_TIMEOUT_DEFAULT;
    }

    public long TOPO_UPDATE_TIMEOUT_DEFAULT() {
        return this.TOPO_UPDATE_TIMEOUT_DEFAULT;
    }

    public boolean TOPO_STATE_TRANSFER_DEFAULT() {
        return this.TOPO_STATE_TRANSFER_DEFAULT;
    }

    private Properties props() {
        return this.props;
    }

    private ProtocolServer server() {
        return this.server;
    }

    private void server_$eq(ProtocolServer x$1) {
        this.server = x$1;
    }

    private EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    private void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public ProtocolServer getServer() {
        return this.server();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    public void main(String[] args) {
        this.logStartWithArgs(Predef$.MODULE$.refArrayOps((Object[])args).mkString(", "));
        Callable<Void> worker = new Callable<Void>(args){
            private final String[] args$1;

            public Null$ call() {
                try {
                    Main$.MODULE$.boot(this.args$1);
                    return null;
                }
                catch (Exception exception) {
                    System.err.println("Failed to boot JBoss:");
                    exception.printStackTrace();
                    throw exception;
                }
            }
            {
                this.args$1 = args$1;
            }
        };
        Future<Void> f = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "InfinispanServer-Main");
            }
        }).submit(worker);
        f.get();
    }

    public void boot(String[] args) {
        String string;
        block7: {
            String string2;
            block5: {
                block6: {
                    block4: {
                        this.processCommandLine(args);
                        String protocol = this.props().getProperty(this.PROP_KEY_PROTOCOL());
                        if (protocol == null) {
                            System.err.println("ERROR: Please indicate protocol to run with -r parameter");
                            this.showAndExit();
                        }
                        String string3 = string = protocol;
                        if ("memcached" != null ? !"memcached".equals(string3) : string3 != null) break block4;
                        String x2 = string;
                        string2 = "org.infinispan.server.memcached.MemcachedServer";
                        break block5;
                    }
                    String string4 = string;
                    if ("hotrod" != null ? !"hotrod".equals(string4) : string4 != null) break block6;
                    String x3 = string;
                    string2 = "org.infinispan.server.hotrod.HotRodServer";
                    break block5;
                }
                String string5 = string;
                if ("websocket" != null ? !"websocket".equals(string5) : string5 != null) break block7;
                String x4 = string;
                string2 = "org.infinispan.server.websocket.WebSocketServer";
            }
            String clazz = string2;
            this.server_$eq((ProtocolServer)Util.getInstance((String)clazz, (ClassLoader)Thread.currentThread().getContextClassLoader()));
            String configFile = this.props().getProperty(this.PROP_KEY_CACHE_CONFIG());
            this.cacheManager_$eq(this.instantiateCacheManager(configFile));
            this.cacheManager().getGlobalConfiguration().setShutdownHookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER);
            this.addShutdownHook(new ShutdownHook(this.server(), (CacheContainer)this.cacheManager()));
            this.server().start(this.props(), this.cacheManager());
            return;
        }
        throw new MatchError((Object)string);
    }

    private EmbeddedCacheManager instantiateCacheManager(String configFile) {
        String clazzName = this.props().getProperty(this.PROP_KEY_CACHE_MANAGER_CLASS());
        Class clazz = clazzName == null ? DefaultCacheManager.class : Class.forName(clazzName);
        return configFile == null ? this.createCacheManagerNoConfig(clazz) : this.createCacheManager(clazz, configFile);
    }

    private EmbeddedCacheManager createCacheManagerNoConfig(Class<EmbeddedCacheManager> clazz) {
        GlobalConfiguration globalCfg = new GlobalConfiguration();
        globalCfg.setExposeGlobalJmxStatistics(true);
        Configuration defaultCfg = new Configuration();
        defaultCfg.setExposeJmxStatistics(true);
        try {
            Constructor<EmbeddedCacheManager> constructor = clazz.getConstructor(GlobalConfiguration.class, Configuration.class);
            return constructor.newInstance(globalCfg, defaultCfg);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString("%s does not have a constructor that takes GlobalConfiguration and Configuration instances")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz})), noSuchMethodException);
        }
    }

    private EmbeddedCacheManager createCacheManager(Class<EmbeddedCacheManager> clazz, String configFile) {
        try {
            Constructor<EmbeddedCacheManager> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(configFile);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString("%s does not have a constructor that takes a config file path")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz})), noSuchMethodException);
        }
    }

    private void processCommandLine(String[] args) {
        String sopts = "-:hD:Vp:l:m:t:c:r:i:n:s:e:o:x:k:u:a:f:d:";
        LongOpt[] longOptArray = new LongOpt[18];
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("version", 0, null, 86);
        longOptArray[2] = new LongOpt("port", 1, null, 112);
        longOptArray[3] = new LongOpt("host", 1, null, 108);
        longOptArray[4] = new LongOpt("master_threads", 1, null, 109);
        longOptArray[5] = new LongOpt("worker_threads", 1, null, 116);
        longOptArray[6] = new LongOpt("cache_config", 1, null, 99);
        longOptArray[7] = new LongOpt("protocol", 1, null, 114);
        longOptArray[8] = new LongOpt("idle_timeout", 1, null, 105);
        longOptArray[9] = new LongOpt("tcp_no_delay", 1, null, 110);
        longOptArray[10] = new LongOpt("send_buf_size", 1, null, 115);
        longOptArray[11] = new LongOpt("recv_buf_size", 1, null, 101);
        longOptArray[12] = new LongOpt("proxy_host", 1, null, 111);
        longOptArray[13] = new LongOpt("topo_lock_timeout", 1, null, 107);
        longOptArray[14] = new LongOpt("topo_repl_timeout", 1, null, 117);
        longOptArray[15] = new LongOpt("topo_state_transfer", 1, null, 97);
        longOptArray[16] = new LongOpt("topo_update_time", 1, null, 100);
        longOptArray[17] = new LongOpt("cache_manager_class", 1, null, 102);
        LongOpt[] lopts = (LongOpt[])((Object[])longOptArray);
        Getopt getopt = new Getopt("startServer", args, sopts, lopts);
        int code = 0;
        while ((code = getopt.getopt()) != -1) {
            int n = code;
            switch (n) {
                default: {
                    throw new Exception(new StringBuilder().append((Object)"unhandled option code: ").append((Object)BoxesRunTime.boxToInteger((int)code)).toString());
                }
                case 68: {
                    String arg = getopt.getOptarg();
                    String name = "";
                    String value = "";
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    Object object = System.setProperty(name, value);
                    break;
                }
                case 102: {
                    Object object = this.props().setProperty(this.PROP_KEY_CACHE_MANAGER_CLASS(), getopt.getOptarg());
                    break;
                }
                case 100: {
                    Object object = this.props().setProperty(this.PROP_KEY_TOPOLOGY_UPDATE_TIMEOUT(), getopt.getOptarg());
                    break;
                }
                case 97: {
                    Object object = this.props().setProperty(this.PROP_KEY_TOPOLOGY_STATE_TRANSFER(), getopt.getOptarg());
                    break;
                }
                case 117: {
                    Object object = this.props().setProperty(this.PROP_KEY_TOPOLOGY_REPL_TIMEOUT(), getopt.getOptarg());
                    break;
                }
                case 107: {
                    Object object = this.props().setProperty(this.PROP_KEY_TOPOLOGY_LOCK_TIMEOUT(), getopt.getOptarg());
                    break;
                }
                case 120: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROXY_PORT(), getopt.getOptarg());
                    break;
                }
                case 111: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROXY_HOST(), getopt.getOptarg());
                    break;
                }
                case 101: {
                    Object object = this.props().setProperty(this.PROP_KEY_RECV_BUF_SIZE(), getopt.getOptarg());
                    break;
                }
                case 115: {
                    Object object = this.props().setProperty(this.PROP_KEY_SEND_BUF_SIZE(), getopt.getOptarg());
                    break;
                }
                case 110: {
                    Object object = this.props().setProperty(this.PROP_KEY_TCP_NO_DELAY(), getopt.getOptarg());
                    break;
                }
                case 105: {
                    Object object = this.props().setProperty(this.PROP_KEY_IDLE_TIMEOUT(), getopt.getOptarg());
                    break;
                }
                case 114: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROTOCOL(), getopt.getOptarg());
                    break;
                }
                case 99: {
                    Object object = this.props().setProperty(this.PROP_KEY_CACHE_CONFIG(), getopt.getOptarg());
                    break;
                }
                case 116: {
                    Object object = this.props().setProperty(this.PROP_KEY_WORKER_THREADS(), getopt.getOptarg());
                    break;
                }
                case 109: {
                    Object object = this.props().setProperty(this.PROP_KEY_MASTER_THREADS(), getopt.getOptarg());
                    break;
                }
                case 108: {
                    Object object = this.props().setProperty(this.PROP_KEY_HOST(), getopt.getOptarg());
                    break;
                }
                case 112: {
                    Object object = this.props().setProperty(this.PROP_KEY_PORT(), getopt.getOptarg());
                    break;
                }
                case 86: {
                    Version.printFullVersionInformation();
                    System.exit(0);
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 104: {
                    this.showAndExit();
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    System.err.println(new StringBuilder().append((Object)"startServer: unused non-option argument: ").append((Object)getopt.getOptarg()).toString());
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 58: 
                case 63: {
                    System.exit(1);
                    Object object = BoxedUnit.UNIT;
                }
            }
        }
    }

    private void addShutdownHook(Thread shutdownHook) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(shutdownHook){
            private final Thread shutdownHook$1;

            public Null$ run() {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook$1);
                return null;
            }
            {
                this.shutdownHook$1 = shutdownHook$1;
            }
        });
    }

    private void showAndExit() {
        Predef$.MODULE$.println((Object)"usage: startServer [options]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"options:");
        Predef$.MODULE$.println((Object)"    -h, --help                         Show this help message");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -V, --version                      Show version information");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    --                                 Stop processing options");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -p, --port=<num>                   TCP port number to listen on (default: 11211 for Memcached, 11222 for Hot Rod and 8181 for WebSocket server)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -l, --host=<host or ip>            Interface to listen on (default: 127.0.0.1, localhost)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -t, --worker_threads=<num>         Number of threads processing incoming requests and sending responses (default: 20 * number of processors)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -c, --cache_config=<filename>      Cache configuration file (default: creates cache with default values)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -r, --protocol=                    Protocol to understand by the server. This is a mandatory option and you should choose one of these options");
        Predef$.MODULE$.println((Object)"          [memcached|hotrod|websocket]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -i, --idle_timeout=<num>           Idle read timeout, in seconds, used to detect stale connections (default: -1).");
        Predef$.MODULE$.println((Object)"                                       If no new messages have been read within this time, the server disconnects the channel.");
        Predef$.MODULE$.println((Object)"                                       Passing -1 disables idle timeout.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -n, --tcp_no_delay=[true|false]    TCP no delay flag switch (default: true).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -s, --send_buf_size=<num>          Send buffer size (default: as defined by the OS).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -e, --recv_buf_size=<num>          Receive buffer size (default: as defined by the OS).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -o, --proxy_host=<host or ip>      Host address to expose in topology information sent to clients.");
        Predef$.MODULE$.println((Object)"                                       If not present, it defaults to configured host.");
        Predef$.MODULE$.println((Object)"                                       Servers that do not transmit topology information ignore this setting.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -x, --proxy_port=<num>             Port to expose in topology information sent to clients. If not present, it defaults to configured port.");
        Predef$.MODULE$.println((Object)"                                       Servers that do not transmit topology information ignore this setting.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -k, --topo_lock_timeout=<num>      Controls lock timeout (in milliseconds) for those servers that maintain the topology information in an internal cache.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -u, --topo_repl_timeout=<num>      Sets the maximum replication time (in milliseconds) for transfer of topology information between servers.");
        Predef$.MODULE$.println((Object)"                                       If state transfer is enabled, this setting also controls the topology cache state transfer timeout.");
        Predef$.MODULE$.println((Object)"                                       If state transfer is disabled, it controls the amount of time to wait for this topology data");
        Predef$.MODULE$.println((Object)"                                       to be lazily loaded from a different node when not present locally.");
        Predef$.MODULE$.println((Object)"                                       This value should be set higher than 'topo_lock_timeout' to allow remote locks to be acquired within the time allocated to replicate the topology.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -a, --topo_state_trasfer=          Enabling topology information state transfer means that when a server starts it retrieves this information from a different node.");
        Predef$.MODULE$.println((Object)"          [true|false]                 Otherwise, if set to false, the topology information is lazily loaded if not available locally.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -d, --topo_update_timeout=<num>    Sets the maximum time (in milliseconds) to wait for topology information to be updated.");
        Predef$.MODULE$.println((Object)"                                       This value should be set higher than 'topo_repl_timeout' to allow retries to happen if a replication timeout is encountered.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -f, --cache_manager_class=<clazz>  Cache manager class name to be used instead of the default one (it has to extend org.infinispan.manager.EmbeddedCacheManager).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -D<name>[=<value>]                 Set a system property");
        Predef$.MODULE$.println();
        System.exit(0);
    }

    private Main$() {
        MODULE$ = this;
        Log$class.$init$(this);
        this.PROP_KEY_PORT = "infinispan.server.port";
        this.PROP_KEY_HOST = "infinispan.server.host";
        this.PROP_KEY_MASTER_THREADS = "infinispan.server.master_threads";
        this.PROP_KEY_WORKER_THREADS = "infinispan.server.worker_threads";
        this.PROP_KEY_CACHE_CONFIG = "infinispan.server.cache_config";
        this.PROP_KEY_PROTOCOL = "infinispan.server.protocol";
        this.PROP_KEY_IDLE_TIMEOUT = "infinispan.server.idle_timeout";
        this.PROP_KEY_TCP_NO_DELAY = "infinispan.server.tcp_no_delay";
        this.PROP_KEY_SEND_BUF_SIZE = "infinispan.server.send_buf_size";
        this.PROP_KEY_RECV_BUF_SIZE = "infinispan.server.recv_buf_size";
        this.PROP_KEY_PROXY_HOST = "infinispan.server.proxy_host";
        this.PROP_KEY_PROXY_PORT = "infinispan.server.proxy_port";
        this.PROP_KEY_TOPOLOGY_LOCK_TIMEOUT = "infinispan.server.topology.lock_timeout";
        this.PROP_KEY_TOPOLOGY_REPL_TIMEOUT = "infinispan.server.topology.repl_timeout";
        this.PROP_KEY_TOPOLOGY_STATE_TRANSFER = "infinispan.server.topology.state_transfer";
        this.PROP_KEY_TOPOLOGY_UPDATE_TIMEOUT = "infinispan.server.topology.update_timeout";
        this.PROP_KEY_CACHE_MANAGER_CLASS = "infinispan.server.cache_manager_class";
        this.HOST_DEFAULT = "127.0.0.1";
        this.WORKER_THREADS_DEFAULT = 2 * Runtime.getRuntime().availableProcessors();
        this.IDLE_TIMEOUT_DEFAULT = -1;
        this.TCP_NO_DELAY_DEFAULT = true;
        this.SEND_BUF_SIZE_DEFAULT = 0;
        this.RECV_BUF_SIZE_DEFAULT = 0;
        this.TOPO_LOCK_TIMEOUT_DEFAULT = 10000L;
        this.TOPO_REPL_TIMEOUT_DEFAULT = 10000L;
        this.TOPO_UPDATE_TIMEOUT_DEFAULT = 30000L;
        this.TOPO_STATE_TRANSFER_DEFAULT = true;
        this.props = new TypedProperties(System.getProperties());
    }
}

