/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.SslConfiguration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001b\t9b*\u001a;us\u000eC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\rM,'O^3s\u0015\tI!\"\u0001\u0006j]\u001aLg.[:qC:T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u00012a\u0004\f\u0019\u001b\u0005\u0001\"BA\t\u0013\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0005\u000b\u0002\u000b9,G\u000f^=\u000b\u0003U\t!![8\n\u0005]\u0001\"AE\"iC:tW\r\\%oSRL\u0017\r\\5{KJ\u0004\"aD\r\n\u0005i\u0001\"aB\"iC:tW\r\u001c\u0005\t\u000f\u0001\u0011\t\u0011)A\u00059A\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\u000f!J|Go\\2pYN+'O^3s\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013aB3oG>$WM\u001d\t\u0003\u001f\rJ!\u0001\n\t\u0003-\rC\u0017M\u001c8fY>+HOY8v]\u0012D\u0015M\u001c3mKJDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDc\u0001\u0015+WA\u0011\u0011\u0006A\u0007\u0002\u0005!)q!\na\u00019!)\u0011%\na\u0001E!)Q\u0006\u0001C!]\u0005Y\u0011N\\5u\u0007\"\fgN\\3m)\tyS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0003V]&$\b\"\u0002\u001c-\u0001\u0004A\u0012AA2i\u0011\u0015A\u0004\u0001\"\u0001:\u0003=\u0019'/Z1uKN\u001bH.\u00128hS:,GC\u0001\u001eE!\tY$)D\u0001=\u0015\tid(A\u0002tg2T!a\u0010!\u0002\u00079,GOC\u0001B\u0003\u0015Q\u0017M^1y\u0013\t\u0019EHA\u0005T'2+enZ5oK\")Qh\u000ea\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nB\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005);%\u0001E*tY\u000e{gNZ5hkJ\fG/[8o\u0001")
public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final ProtocolServer server;
    private final ChannelOutboundHandler encoder;

    public void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        SslConfiguration ssl = this.server.getConfiguration().ssl();
        Object object = ssl.enabled() ? pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.createSslEngine(ssl))) : BoxedUnit.UNIT;
        pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    public SSLEngine createSslEngine(SslConfiguration ssl) {
        SSLContext sslContext = ssl.sslContext() == null ? SslContextFactory.getContext((String)ssl.keyStoreFileName(), (char[])ssl.keyStorePassword(), (String)ssl.trustStoreFileName(), (char[])ssl.trustStorePassword()) : ssl.sslContext();
        return SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)ssl.requireClientAuth());
    }

    public NettyChannelInitializer(ProtocolServer server, ChannelOutboundHandler encoder) {
        this.server = server;
        this.encoder = encoder;
    }
}

