/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;

public final class SaslUtils {
    private SaslUtils() {
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslServerFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories() {
        return SaslUtils.getFactories(SaslServerFactory.class, null, true);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslClientFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories() {
        return SaslUtils.getFactories(SaslClientFactory.class, null, true);
    }

    private static <T> Iterator<T> getFactories(Class<T> type, ClassLoader classLoader, boolean includeGlobal) {
        LinkedHashSet<T> factories = new LinkedHashSet<T>();
        ServiceLoader<T> loader = ServiceLoader.load(type, classLoader);
        for (T factory : loader) {
            factories.add(factory);
        }
        if (includeGlobal) {
            Provider[] providers;
            HashSet<String> loadedClasses = new HashSet<String>();
            String filter = type.getSimpleName() + ".";
            for (Provider currentProvider : providers = Security.getProviders()) {
                ClassLoader cl = currentProvider.getClass().getClassLoader();
                for (Object currentKey : currentProvider.keySet()) {
                    String className;
                    if (!(currentKey instanceof String) || !((String)currentKey).startsWith(filter) || ((String)currentKey).indexOf(32) >= 0 || (className = currentProvider.getProperty((String)currentKey)) == null || !loadedClasses.add(className)) continue;
                    try {
                        factories.add(Class.forName(className, true, cl).asSubclass(type).newInstance());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
        }
        return factories.iterator();
    }
}

