/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.net.SocketAddress;
import java.util.List;
import javax.security.sasl.SaslServer;

public class SaslQopHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private final SaslServer server;
    private final int maxBufferSize;
    private final int maxSendBufferSize;
    private int packetLength = -1;

    public SaslQopHandler(SaslServer server) {
        this.server = server;
        String maxBuf = (String)server.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        this.maxBufferSize = maxBuf != null ? Integer.parseInt(maxBuf) : -1;
        String maxSendBuf = (String)server.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        this.maxSendBufferSize = maxSendBuf != null ? Integer.parseInt(maxSendBuf) : -1;
    }

    private static byte[] readBytes(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        buffer.release();
        return bytes;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        int len;
        int offset;
        byte[] bytes;
        ByteBuf buffer = (ByteBuf)msg;
        if (buffer.hasArray()) {
            bytes = buffer.array();
            offset = buffer.arrayOffset() + buffer.readerIndex();
            len = buffer.readableBytes();
        } else {
            bytes = SaslQopHandler.readBytes(buffer);
            offset = 0;
            len = bytes.length;
        }
        byte[] wrapped = this.server.wrap(bytes, offset, len);
        ctx.write((Object)ctx.alloc().buffer(4).writeInt(wrapped.length));
        if (this.maxSendBufferSize != -1 && wrapped.length > this.maxSendBufferSize) {
            int size = wrapped.length;
            int off = 0;
            while (true) {
                if (size < this.maxSendBufferSize) {
                    ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])wrapped, (int)off, (int)size), promise);
                    return;
                }
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])wrapped, (int)off, (int)this.maxSendBufferSize));
                off += this.maxSendBufferSize;
                size -= this.maxSendBufferSize;
            }
        }
        ctx.write((Object)Unpooled.wrappedBuffer((byte[])wrapped), promise);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte[] array;
        int offset;
        int len = this.packetLength;
        if (len == -1) {
            if (in.readableBytes() < 4) {
                return;
            }
            len = this.packetLength = (int)in.readUnsignedInt();
            if (this.maxBufferSize != -1 && this.maxBufferSize < this.packetLength) {
                TooLongFrameException ex = new TooLongFrameException("Frame exceed exceed max buffer size: " + this.packetLength + " > " + this.maxBufferSize);
                ctx.fireExceptionCaught((Throwable)ex);
                ctx.close();
                return;
            }
        }
        if (len > in.readableBytes()) {
            return;
        }
        this.packetLength = -1;
        if (in.hasArray()) {
            offset = in.readerIndex() + in.arrayOffset();
            array = in.array();
            in.skipBytes(len);
        } else {
            offset = 0;
            array = new byte[len];
            in.readBytes(array);
        }
        out.add(Unpooled.wrappedBuffer((byte[])this.server.unwrap(array, offset, len)));
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved0(ctx);
        this.server.dispose();
    }
}

