/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin;

import io.netty.util.CharsetUtil;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminFlag;
import org.infinispan.server.core.logging.Log;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.TaskContext;
import org.infinispan.util.logging.LogFactory;

public abstract class AdminServerTask<T>
implements ServerTask<T> {
    protected EmbeddedCacheManager cacheManager;
    protected final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private Map<String, String> parameters;
    private EnumSet<AdminFlag> flags;

    public final String getName() {
        return "@@" + this.getTaskContextName() + "@" + this.getTaskOperationName();
    }

    public final void setTaskContext(TaskContext taskContext) {
        this.cacheManager = taskContext.getCacheManager();
        Map rawParams = (Map)taskContext.getParameters().get();
        this.parameters = rawParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new String((byte[])entry.getValue(), CharsetUtil.UTF_8)));
        String sFlags = this.parameters.remove("flags");
        this.flags = AdminFlag.fromString(sFlags);
    }

    public boolean isPersistent() {
        return this.flags.contains((Object)AdminFlag.PERSISTENT);
    }

    protected String requireParameter(String parameter) {
        String v = this.parameters.get(parameter);
        if (v == null) {
            throw this.log.missingRequiredAdminTaskParameter(this.getName(), parameter);
        }
        return v;
    }

    protected String getParameter(String parameter) {
        return this.parameters.get(parameter);
    }

    public abstract String getTaskContextName();

    public abstract String getTaskOperationName();
}

