/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import org.infinispan.server.core.utils.SslUtils;

public class NettyChannelInitializer<A extends ProtocolServerConfiguration>
implements NettyInitializer {
    protected final ProtocolServer<A> server;
    protected final NettyTransport transport;
    protected final ChannelOutboundHandler encoder;
    protected final ChannelInboundHandler decoder;

    public NettyChannelInitializer(ProtocolServer<A> server, NettyTransport transport, ChannelOutboundHandler encoder, ChannelInboundHandler decoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public void initializeChannel(Channel ch) throws Exception {
        SslConfiguration ssl;
        ChannelPipeline pipeline = ch.pipeline();
        if (this.transport != null) {
            pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler(this.transport));
        }
        if ((ssl = ((ProtocolServerConfiguration)this.server.getConfiguration()).ssl()).enabled()) {
            ApplicationProtocolConfig alpnConfig = this.getAlpnConfiguration();
            JdkSslContext defaultNettySslContext = SslUtils.createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"), alpnConfig);
            DomainNameMappingBuilder domainMappingBuilder = new DomainNameMappingBuilder((Object)defaultNettySslContext);
            ssl.sniDomainsConfiguration().forEach((k, v) -> {
                if (!"*".equals(k)) {
                    domainMappingBuilder.add(k, (Object)SslUtils.createNettySslContext(ssl, v, alpnConfig));
                }
            });
            pipeline.addLast("sni", (ChannelHandler)new SniHandler((DomainNameMapping<? extends SslContext>)domainMappingBuilder.build()));
        }
        if (this.decoder != null) {
            pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        }
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        return null;
    }
}

