/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.infinispan.server.core.configuration.SslEngineConfiguration;

public class SslConfiguration {
    public static final String DEFAULT_SNI_DOMAIN = "*";
    private final boolean enabled;
    private final boolean requireClientAuth;
    private final Map<String, SslEngineConfiguration> sniDomainsConfiguration;

    SslConfiguration(boolean enabled, boolean requireClientAuth, Map<String, SslEngineConfiguration> sniDomainsConfiguration) {
        this.enabled = enabled;
        this.requireClientAuth = requireClientAuth;
        this.sniDomainsConfiguration = sniDomainsConfiguration;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean requireClientAuth() {
        return this.requireClientAuth;
    }

    public String keyStoreFileName() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStoreFileName();
    }

    public char[] keyStorePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStorePassword();
    }

    public char[] keyStoreCertificatePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStoreCertificatePassword();
    }

    public SSLContext sslContext() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).sslContext();
    }

    public String trustStoreFileName() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).trustStoreFileName();
    }

    public char[] trustStorePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).trustStorePassword();
    }

    public Map<String, SslEngineConfiguration> sniDomainsConfiguration() {
        return this.sniDomainsConfiguration;
    }

    public String toString() {
        return "SslConfiguration [enabled=" + this.enabled + ", requireClientAuth=" + this.requireClientAuth + ", sniDomainsConfiguration=" + this.sniDomainsConfiguration + ']';
    }
}

