/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.SslConfiguration;

public abstract class ProtocolServerConfiguration {
    public static final AttributeDefinition<String> DEFAULT_CACHE_NAME = AttributeDefinition.builder((String)"default-cache", (Object)"___defaultcache").immutable().build();
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", (Object)"").immutable().build();
    public static final AttributeDefinition<String> HOST = AttributeDefinition.builder((String)"host", (Object)"127.0.0.1").immutable().build();
    public static final AttributeDefinition<Integer> PORT = AttributeDefinition.builder((String)"port", (Object)-1).immutable().build();
    public static final AttributeDefinition<Integer> IDLE_TIMEOUT = AttributeDefinition.builder((String)"idle-timeout", (Object)-1).immutable().build();
    public static final AttributeDefinition<Set<String>> IGNORED_CACHES = AttributeDefinition.builder((String)"ignored-caches", Collections.emptySet(), Set.class).immutable().build();
    public static final AttributeDefinition<Integer> RECV_BUF_SIZE = AttributeDefinition.builder((String)"recv-buffer-size", (Object)0).immutable().build();
    public static final AttributeDefinition<Integer> SEND_BUF_SIZE = AttributeDefinition.builder((String)"send-buffer-size", (Object)0).immutable().build();
    public static final AttributeDefinition<Boolean> START_TRANSPORT = AttributeDefinition.builder((String)"start-transport", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> TCP_NODELAY = AttributeDefinition.builder((String)"tcp-nodelay", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> TCP_KEEPALIVE = AttributeDefinition.builder((String)"tcp-keepalive", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> IO_THREADS = AttributeDefinition.builder((String)"io-threads", (Object)(2 * ProcessorInfo.availableProcessors())).immutable().build();
    public static final AttributeDefinition<Integer> WORKER_THREADS = AttributeDefinition.builder((String)"worker-threads", (Object)160).immutable().build();
    public static final AttributeDefinition<AdminOperationsHandler> ADMIN_OPERATION_HANDLER = AttributeDefinition.builder((String)"admin-operation-handler", null, AdminOperationsHandler.class).immutable().build();
    public static final AttributeDefinition<Boolean> ZERO_CAPACITY_NODE = AttributeDefinition.builder((String)"zero-capacity-node", (Object)false).immutable().build();
    private final Attribute<String> defaultCacheName;
    private final Attribute<String> name;
    private final Attribute<String> host;
    private final Attribute<Integer> port;
    private final Attribute<Integer> idleTimeout;
    private final Attribute<Integer> recvBufSize;
    private final Attribute<Integer> sendBufSize;
    private final Attribute<Boolean> tcpNoDelay;
    private final Attribute<Boolean> tcpKeepAlive;
    private final Attribute<Integer> ioThreads;
    private final Attribute<Integer> workerThreads;
    private final Attribute<Set<String>> ignoredCaches;
    private final Attribute<Boolean> startTransport;
    private final Attribute<AdminOperationsHandler> adminOperationsHandler;
    private final Attribute<Boolean> zeroCapacityNode;
    protected final AttributeSet attributes;
    protected final SslConfiguration ssl;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ProtocolServerConfiguration.class, new AttributeDefinition[]{DEFAULT_CACHE_NAME, NAME, HOST, PORT, IDLE_TIMEOUT, IGNORED_CACHES, RECV_BUF_SIZE, SEND_BUF_SIZE, START_TRANSPORT, TCP_NODELAY, TCP_KEEPALIVE, IO_THREADS, WORKER_THREADS, ADMIN_OPERATION_HANDLER, ZERO_CAPACITY_NODE});
    }

    protected ProtocolServerConfiguration(AttributeSet attributes, SslConfiguration ssl) {
        this.attributes = attributes.checkProtection();
        this.ssl = ssl;
        this.defaultCacheName = attributes.attribute(DEFAULT_CACHE_NAME);
        this.zeroCapacityNode = attributes.attribute(ZERO_CAPACITY_NODE);
        this.name = attributes.attribute(NAME);
        this.host = attributes.attribute(HOST);
        this.port = attributes.attribute(PORT);
        this.idleTimeout = attributes.attribute(IDLE_TIMEOUT);
        this.ignoredCaches = attributes.attribute(IGNORED_CACHES);
        this.recvBufSize = attributes.attribute(RECV_BUF_SIZE);
        this.sendBufSize = attributes.attribute(SEND_BUF_SIZE);
        this.startTransport = attributes.attribute(START_TRANSPORT);
        this.tcpNoDelay = attributes.attribute(TCP_NODELAY);
        this.tcpKeepAlive = attributes.attribute(TCP_KEEPALIVE);
        this.ioThreads = attributes.attribute(IO_THREADS);
        this.workerThreads = attributes.attribute(WORKER_THREADS);
        this.adminOperationsHandler = attributes.attribute(ADMIN_OPERATION_HANDLER);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String defaultCacheName() {
        return (String)this.defaultCacheName.get();
    }

    public String name() {
        return (String)this.name.get();
    }

    public String host() {
        return (String)this.host.get();
    }

    public int port() {
        return (Integer)this.port.get();
    }

    public int idleTimeout() {
        return (Integer)this.idleTimeout.get();
    }

    public int recvBufSize() {
        return (Integer)this.recvBufSize.get();
    }

    public int sendBufSize() {
        return (Integer)this.sendBufSize.get();
    }

    public SslConfiguration ssl() {
        return this.ssl;
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.tcpNoDelay.get();
    }

    public boolean tcpKeepAlive() {
        return (Boolean)this.tcpKeepAlive.get();
    }

    public int ioThreads() {
        return (Integer)this.ioThreads.get();
    }

    public int workerThreads() {
        return (Integer)this.workerThreads.get();
    }

    public Set<String> ignoredCaches() {
        return (Set)this.ignoredCaches.get();
    }

    public boolean startTransport() {
        return (Boolean)this.startTransport.get();
    }

    public AdminOperationsHandler adminOperationsHandler() {
        return (AdminOperationsHandler)this.adminOperationsHandler.get();
    }

    public boolean zeroCapacityNode() {
        return (Boolean)this.zeroCapacityNode.get();
    }

    public String toString() {
        return "ProtocolServerConfiguration[" + this.attributes + "]";
    }
}

