/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JBossMarshallingTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JBossMarshallingTranscoder.class, Log.class);
    private final Transcoder jsonObjectTranscoder;
    private final GenericJBossMarshaller marshaller;

    public JBossMarshallingTranscoder(JsonTranscoder jsonObjectTranscoder, GenericJBossMarshaller marshaller) {
        super(MediaType.APPLICATION_JBOSS_MARSHALLING, new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON, MediaType.APPLICATION_UNKNOWN});
        this.jsonObjectTranscoder = jsonObjectTranscoder;
        this.marshaller = marshaller;
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            Object decoded = content;
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                decoded = StandardConversions.decodeOctetStream((Object)content, (MediaType)destinationType);
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                decoded = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
            }
            if (contentType.match(MediaType.APPLICATION_JSON)) {
                decoded = this.jsonObjectTranscoder.transcode(content, contentType, MediaType.APPLICATION_OBJECT);
            }
            if (contentType.match(MediaType.APPLICATION_UNKNOWN) || contentType.match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
                return content;
            }
            return this.marshall(decoded);
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            try {
                Object unmarshalled = this.unmarshall(content);
                if (unmarshalled instanceof byte[]) {
                    return unmarshalled;
                }
                return StandardConversions.convertJavaToOctetStream((Object)unmarshalled, (MediaType)MediaType.APPLICATION_OBJECT, (Marshaller)this.marshaller);
            }
            catch (IOException | InterruptedException e) {
                throw logger.unsupportedContent(content);
            }
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            String unmarshalled = this.unmarshall(content).toString();
            return unmarshalled.getBytes(destinationType.getCharset());
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            return this.unmarshall(content);
        }
        if (destinationType.match(MediaType.APPLICATION_JSON)) {
            Object unmarshalled = this.unmarshall(content);
            Object result = this.jsonObjectTranscoder.transcode(unmarshalled, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON);
            return StandardConversions.convertTextToOctetStream((Object)result, (MediaType)MediaType.APPLICATION_JSON);
        }
        if (destinationType.equals((Object)MediaType.APPLICATION_UNKNOWN)) {
            try {
                if (content instanceof WrappedByteArray) {
                    return content;
                }
                return StandardConversions.convertJavaToOctetStream((Object)content, (MediaType)MediaType.APPLICATION_OBJECT, (Marshaller)this.marshaller);
            }
            catch (IOException | InterruptedException e) {
                throw logger.unsupportedContent(content);
            }
        }
        throw logger.unsupportedContent(content);
    }

    private byte[] marshall(Object o) {
        try {
            return this.marshaller.objectToByteBuffer(o);
        }
        catch (IOException | InterruptedException e) {
            throw logger.errorTranscoding((Throwable)e);
        }
    }

    private Object unmarshall(Object o) {
        try {
            return o instanceof byte[] ? this.marshaller.objectFromByteBuffer((byte[])o) : o;
        }
        catch (IOException | ClassNotFoundException e) {
            throw logger.errorTranscoding((Throwable)e);
        }
    }
}

