/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.utils;

import io.netty.handler.ssl.AlpnHackedJdkSslContext;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.utils.SecurityActions;

public class SslUtils {
    public static JdkSslContext createNettySslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration, ApplicationProtocolConfig alpnConfig) {
        return SslUtils.createSslContext(SslUtils.createJdkSslContext(sslConfiguration, sslEngineConfiguration), SslUtils.requireClientAuth(sslConfiguration), alpnConfig);
    }

    public static SSLContext createJdkSslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration) {
        if (sslEngineConfiguration.sslContext() != null) {
            return sslEngineConfiguration.sslContext();
        }
        return SslContextFactory.getContext((String)sslEngineConfiguration.keyStoreFileName(), (String)sslEngineConfiguration.keyStoreType(), (char[])sslEngineConfiguration.keyStorePassword(), (char[])sslEngineConfiguration.keyStoreCertificatePassword(), (String)sslEngineConfiguration.keyAlias(), (String)sslEngineConfiguration.trustStoreFileName(), (String)sslEngineConfiguration.trustStoreType(), (char[])sslEngineConfiguration.trustStorePassword(), (String)sslEngineConfiguration.protocol(), null);
    }

    private static JdkSslContext createSslContext(SSLContext sslContext, ClientAuth clientAuth, ApplicationProtocolConfig alpnConfig) {
        String[] ciphers = SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (clientAuth == ClientAuth.REQUIRE ? 1 : 0) != 0).getSupportedCipherSuites();
        if (alpnConfig != null && !SslUtils.isJdkAlpn()) {
            return new AlpnHackedJdkSslContext(sslContext, false, Arrays.asList(ciphers), IdentityCipherSuiteFilter.INSTANCE, alpnConfig, clientAuth);
        }
        return new JdkSslContext(sslContext, false, Arrays.asList(ciphers), IdentityCipherSuiteFilter.INSTANCE, alpnConfig, clientAuth);
    }

    private static ClientAuth requireClientAuth(SslConfiguration sslConfig) {
        return sslConfig.requireClientAuth() ? ClientAuth.REQUIRE : ClientAuth.NONE;
    }

    private static boolean isJdkAlpn() {
        return !SecurityActions.getSystemProperty("java.version").startsWith("1.8");
    }
}

