/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.security.auth.Subject;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;

class CounterRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(CounterRequestProcessor.class, Log.class);
    private final ClientCounterManagerNotificationManager notificationManager;
    private final EmbeddedCounterManager counterManager;
    private final BiConsumer<HotRodHeader, StrongCounter> handleStrongGet = this::handleGetStrong;
    private final BiConsumer<HotRodHeader, WeakCounter> handleWeakGet = this::handleGetWeak;
    private final BiConsumer<HotRodHeader, StrongCounter> handleStrongReset = this::handleResetStrong;
    private final BiConsumer<HotRodHeader, WeakCounter> handleWeakReset = this::handleResetWeak;

    CounterRequestProcessor(Channel channel, EmbeddedCounterManager counterManager, Executor executor, HotRodServer server) {
        super(channel, executor, server);
        this.counterManager = counterManager;
        this.notificationManager = server.getClientCounterNotificationManager();
    }

    private EmbeddedCounterManager counterManager(HotRodHeader header) {
        header.cacheName = "org.infinispan.COUNTER";
        return this.counterManager;
    }

    void removeCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        this.executor.execute(() -> this.removeCounterListenerInternal(header, counterName, listenerId));
    }

    private void removeCounterListenerInternal(HotRodHeader header, String counterName, byte[] listenerId) {
        try {
            this.writeResponse(header, this.createResponseFrom(header, this.notificationManager.removeCounterListener(listenerId, counterName)));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void addCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        this.executor.execute(() -> this.addCounterListenerInternal(header, counterName, listenerId));
    }

    private void addCounterListenerInternal(HotRodHeader header, String counterName, byte[] listenerId) {
        try {
            this.writeResponse(header, this.createResponseFrom(header, this.notificationManager.addCounterListener(listenerId, header.getVersion(), counterName, this.channel, header.encoder())));
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void getCounterNames(HotRodHeader header, Subject subject) {
        Collection counterNames = this.counterManager(header).getCounterNames();
        this.writeResponse(header, header.encoder().counterNamesResponse(header, this.server, this.channel, counterNames));
    }

    void counterRemove(HotRodHeader header, Subject subject, String counterName) {
        this.executor.execute(() -> this.counterRemoveInternal(header, counterName));
    }

    private void counterRemoveInternal(HotRodHeader header, String counterName) {
        try {
            this.counterManager(header).remove(counterName);
            this.writeSuccess(header);
        }
        catch (Throwable t) {
            this.writeException(header, t);
        }
    }

    void counterCompareAndSwap(HotRodHeader header, Subject subject, String counterName, long expect, long update) {
        this.applyCounter(header, counterName, (h, counter) -> counter.compareAndSwap(expect, update).whenComplete((value, throwable) -> this.longResultHandler((HotRodHeader)h, (Long)value, (Throwable)throwable)), (h, counter) -> this.writeException((HotRodHeader)h, (Throwable)log.invalidWeakCounter(counterName)));
    }

    void counterGet(HotRodHeader header, Subject subject, String counterName) {
        this.applyCounter(header, counterName, this.handleStrongGet, this.handleWeakGet);
    }

    private void handleGetStrong(HotRodHeader header, StrongCounter counter) {
        counter.getValue().whenComplete((value, throwable) -> this.longResultHandler(header, (Long)value, (Throwable)throwable));
    }

    private void handleGetWeak(HotRodHeader header, WeakCounter counter) {
        this.longResultHandler(header, counter.getValue(), null);
    }

    void counterReset(HotRodHeader header, Subject subject, String counterName) {
        this.applyCounter(header, counterName, this.handleStrongReset, this.handleWeakReset);
    }

    private void handleResetStrong(HotRodHeader header, StrongCounter counter) {
        counter.reset().whenComplete((value, throwable) -> this.voidResultHandler(header, (Throwable)throwable));
    }

    private void handleResetWeak(HotRodHeader header, WeakCounter counter) {
        counter.reset().whenComplete((value, throwable) -> this.voidResultHandler(header, (Throwable)throwable));
    }

    void counterAddAndGet(HotRodHeader header, Subject subject, String counterName, long value) {
        this.applyCounter(header, counterName, (h, counter) -> counter.addAndGet(value).whenComplete((value1, throwable) -> this.longResultHandler((HotRodHeader)h, (Long)value1, (Throwable)throwable)), (h, counter) -> counter.add(value).whenComplete((value2, throwable1) -> this.longResultHandler((HotRodHeader)h, 0L, (Throwable)throwable1)));
    }

    void getCounterConfiguration(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getConfigurationAsync(counterName).whenComplete((configuration, throwable) -> this.handleGetCounterConfiguration(header, (CounterConfiguration)configuration, (Throwable)throwable));
    }

    private void handleGetCounterConfiguration(HotRodHeader header, CounterConfiguration configuration, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            ByteBuf response = configuration == null ? this.missingCounterResponse(header) : header.encoder().counterConfigurationResponse(header, this.server, this.channel, configuration);
            this.writeResponse(header, response);
        }
    }

    void isCounterDefined(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).isDefinedAsync(counterName).whenComplete((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable));
    }

    void createCounter(HotRodHeader header, Subject subject, String counterName, CounterConfiguration configuration) {
        this.counterManager(header).defineCounterAsync(counterName, configuration).whenComplete((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable));
    }

    private void applyCounter(HotRodHeader header, String counterName, BiConsumer<HotRodHeader, StrongCounter> applyStrong, BiConsumer<HotRodHeader, WeakCounter> applyWeak) {
        EmbeddedCounterManager counterManager = this.counterManager(header);
        CounterConfiguration config = counterManager.getConfiguration(counterName);
        if (config == null) {
            this.writeResponse(header, this.missingCounterResponse(header));
            return;
        }
        switch (config.type()) {
            case UNBOUNDED_STRONG: 
            case BOUNDED_STRONG: {
                applyStrong.accept(header, counterManager.getStrongCounter(counterName));
                break;
            }
            case WEAK: {
                applyWeak.accept(header, counterManager.getWeakCounter(counterName));
            }
        }
    }

    private ByteBuf createResponseFrom(HotRodHeader header, ListenerOperationStatus status) {
        switch (status) {
            case OK: {
                return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.OperationNotExecuted);
            }
            case OK_AND_CHANNEL_IN_USE: {
                return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success);
            }
            case COUNTER_NOT_FOUND: {
                return this.missingCounterResponse(header);
            }
        }
        throw new IllegalStateException();
    }

    private void checkCounterThrowable(HotRodHeader header, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterOutOfBoundsException) {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.NotExecutedWithPrevious));
        } else {
            this.writeException(header, cause);
        }
    }

    private ByteBuf missingCounterResponse(HotRodHeader header) {
        return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.KeyDoesNotExist);
    }

    private void booleanResultHandler(HotRodHeader header, Boolean value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            OperationStatus status = value != false ? OperationStatus.Success : OperationStatus.OperationNotExecuted;
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, status));
        }
    }

    private void longResultHandler(HotRodHeader header, Long value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().longResponse(header, this.server, this.channel, value));
        }
    }

    private void voidResultHandler(HotRodHeader header, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
        }
    }
}

