/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.configuration.SaslAuthenticationConfiguration;
import org.infinispan.server.core.configuration.SaslConfiguration;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;

public class Authentication
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(Authentication.class, Log.class);
    private static final Subject ANONYMOUS = new Subject();
    public static final String HOTROD_SASL_PROTOCOL = "hotrod";
    private final HotRodServerConfiguration serverConfig;
    private final SaslAuthenticationConfiguration authenticationConfig;
    private final boolean enabled;
    private final boolean requireAuthentication;
    private SaslServer saslServer;
    private Subject subject = ANONYMOUS;

    public Authentication(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
        this.serverConfig = (HotRodServerConfiguration)server.getConfiguration();
        this.authenticationConfig = this.serverConfig.authentication();
        this.enabled = this.authenticationConfig.enabled();
        this.requireAuthentication = !this.authenticationConfig.sasl().mechProperties().containsKey("javax.security.sasl.policy.noanonymous") || "true".equals(this.authenticationConfig.sasl().mechProperties().get("javax.security.sasl.policy.noanonymous"));
    }

    public void authMechList(HotRodHeader header) {
        this.writeResponse(header, header.encoder().authMechListResponse(header, this.server, this.channel, this.authenticationConfig.sasl().mechanisms()));
    }

    public void auth(HotRodHeader header, String mech, byte[] response) {
        if (!this.enabled) {
            UnsupportedOperationException cause = log.invalidOperation();
            ByteBuf buf = header.encoder().errorResponse(header, this.server, this.channel, cause.toString(), OperationStatus.ServerError);
            int responseBytes = buf.readableBytes();
            ChannelFuture future = this.channel.writeAndFlush((Object)buf);
            if (header instanceof AccessLoggingHeader) {
                this.server.accessLogging().logException(future, (AccessLoggingHeader)header, cause.toString(), responseBytes);
            }
        } else {
            this.executor.execute(() -> {
                try {
                    this.authInternal(header, mech, response);
                }
                catch (Throwable t) {
                    this.disposeSaslServer();
                    String message = t.getMessage();
                    if (message.startsWith("ELY05055") || message.startsWith("ELY05051")) {
                        this.writeException(header, log.authenticationException(t));
                    }
                    this.writeException(header, t);
                }
            });
        }
    }

    private void authInternal(HotRodHeader header, String mech, byte[] response) throws Throwable {
        if (this.saslServer == null) {
            this.saslServer = SaslAuthenticator.createSaslServer((SaslConfiguration)this.serverConfig.authentication().sasl(), (Channel)this.channel, (String)mech, (String)HOTROD_SASL_PROTOCOL);
            if (this.saslServer == null) {
                throw log.invalidMech(mech);
            }
        }
        byte[] serverChallenge = this.saslServer.evaluateResponse(response);
        if (this.saslServer.isComplete()) {
            this.authComplete(header, serverChallenge);
        } else {
            this.writeResponse(header, header.encoder().authResponse(header, this.server, this.channel, serverChallenge));
        }
    }

    private void authComplete(HotRodHeader header, byte[] serverChallenge) {
        this.subject = (Subject)this.saslServer.getNegotiatedProperty("org.infinispan.security.Subject");
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)this.channel);
        metadata.subject(this.subject);
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        if ("auth-int".equals(qop) || "auth-conf".equals(qop)) {
            this.channel.eventLoop().submit(() -> {
                this.writeResponse(header, header.encoder().authResponse(header, this.server, this.channel, serverChallenge));
                SaslQopHandler qopHandler = new SaslQopHandler(this.saslServer);
                this.channel.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
            });
        } else {
            this.writeResponse(header, header.encoder().authResponse(header, this.server, this.channel, serverChallenge));
            this.disposeSaslServer();
            this.saslServer = null;
        }
    }

    private void disposeSaslServer() {
        try {
            if (this.saslServer != null) {
                this.saslServer.dispose();
            }
        }
        catch (SaslException e) {
            log.debug("Exception while disposing SaslServer", e);
        }
        finally {
            this.saslServer = null;
        }
    }

    public Subject getSubject(HotRodOperation operation) {
        if (!this.enabled || !operation.requiresAuthentication()) {
            return null;
        }
        if (this.requireAuthentication && this.subject == ANONYMOUS) {
            throw log.unauthorizedOperation(operation.name());
        }
        return this.subject;
    }
}

