/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.operation;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.functions.SetCompletedTransactionFunction;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.ByteString;

public class Util {
    public static void rollbackLocalTransaction(AdvancedCache<?, ?> cache, XidImpl xid, long timeout) throws HeuristicRollbackException, HeuristicMixedException {
        try {
            Util.completeLocalTransaction(cache, xid, timeout, false);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    public static void commitLocalTransaction(AdvancedCache<?, ?> cache, XidImpl xid, long timeout) throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
        Util.completeLocalTransaction(cache, xid, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void completeLocalTransaction(AdvancedCache<?, ?> cache, XidImpl xid, long timeout, boolean commit) throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
        PerCacheTxTable perCacheTxTable = (PerCacheTxTable)ComponentRegistry.componentOf(cache, PerCacheTxTable.class);
        GlobalTxTable globalTxTable = (GlobalTxTable)ComponentRegistry.componentOf(cache, GlobalTxTable.class);
        try {
            EmbeddedTransaction tx = perCacheTxTable.getLocalTx(xid);
            tx.runCommit(!commit);
            CacheXid cacheXid = new CacheXid(ByteString.fromString((String)cache.getName()), xid);
            SetCompletedTransactionFunction function = new SetCompletedTransactionFunction(commit);
            globalTxTable.update(cacheXid, function, timeout);
        }
        finally {
            perCacheTxTable.removeLocalTx(xid);
        }
    }
}

