/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.Security;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheDecodeContext {
    private static final long MillisecondsIn30days = TimeUnit.DAYS.toMillis(30L);
    private static final Log log = (Log)LogFactory.getLog(CacheDecodeContext.class, Log.class);
    private final HotRodServer server;
    Object resource;
    VersionedDecoder decoder;
    HotRodHeader header;
    byte[] key;
    RequestParameters params;
    Object operationDecodeContext;
    Subject subject;

    CacheDecodeContext(HotRodServer server) {
        this.server = server;
    }

    public HotRodHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return (byte[])this.operationDecodeContext;
    }

    public RequestParameters getParams() {
        return this.params;
    }

    <T> T operationContext(Supplier<T> constructor) {
        T opCtx = this.operationContext();
        if (opCtx == null) {
            opCtx = constructor.get();
            this.operationDecodeContext = opCtx;
            return opCtx;
        }
        return opCtx;
    }

    <T> T operationContext() {
        return (T)this.operationDecodeContext;
    }

    ErrorResponse createExceptionResponse(Throwable e) {
        if (e instanceof InvalidMagicIdException) {
            log.exceptionReported(e);
            return new ErrorResponse(0, 0L, "", 1, OperationStatus.InvalidMagicOrMsgId, 0, e.toString());
        }
        if (e instanceof HotRodUnknownOperationException) {
            log.exceptionReported(e);
            HotRodUnknownOperationException hruoe = (HotRodUnknownOperationException)e;
            return new ErrorResponse(hruoe.version, hruoe.messageId, "", 1, OperationStatus.UnknownOperation, 0, e.toString());
        }
        if (e instanceof UnknownVersionException) {
            log.exceptionReported(e);
            UnknownVersionException uve = (UnknownVersionException)e;
            return new ErrorResponse(uve.version, uve.messageId, "", 1, OperationStatus.UnknownVersion, 0, e.toString());
        }
        if (e instanceof RequestParsingException) {
            if (e instanceof CacheNotFoundException) {
                log.debug(e.getMessage());
            } else {
                log.exceptionReported(e);
            }
            String msg = e.getCause() == null ? e.toString() : String.format("%s: %s", e.getMessage(), e.getCause().toString());
            RequestParsingException rpe = (RequestParsingException)e;
            return new ErrorResponse(rpe.version, rpe.messageId, "", 1, OperationStatus.ParseError, 0, msg);
        }
        if (e instanceof IllegalStateException) {
            log.exceptionReported(e);
            return this.decoder.createErrorResponse(this.header, e);
        }
        if (this.decoder != null) {
            return this.decoder.createErrorResponse(this.header, e);
        }
        log.exceptionReported(e);
        return new ErrorResponse(0, 0L, "", 1, OperationStatus.ServerError, 1, e.toString());
    }

    void withSubect(Subject subject) {
        this.subject = subject;
    }

    public String getPrincipalName() {
        return this.subject != null ? Security.getSubjectUserPrincipal((Subject)this.subject).getName() : null;
    }

    Metadata buildMetadata() {
        return this.buildMetadata(this.params.lifespan, this.params.maxIdle);
    }

    Metadata buildMetadata(ExpirationParam lifespan, ExpirationParam maxIdle) {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        metadata.version(this.generateVersion(this.server.getCacheRegistry(this.header.cacheName)));
        if (lifespan.duration != -2L) {
            metadata.lifespan(CacheDecodeContext.toMillis(lifespan));
        }
        if (maxIdle.duration != -2L) {
            metadata.maxIdle(CacheDecodeContext.toMillis(maxIdle));
        }
        return metadata.build();
    }

    private EntryVersion generateVersion(ComponentRegistry registry) {
        VersionGenerator cacheVersionGenerator = registry.getVersionGenerator();
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerVersionGenerator(newVersionGenerator);
            return newVersionGenerator.generateNew();
        }
        return cacheVersionGenerator.generateNew();
    }

    ComponentRegistry getCacheRegistry(String cacheName) {
        return this.server.getCacheRegistry(cacheName);
    }

    public AdvancedCache<byte[], byte[]> cache() {
        return (AdvancedCache)this.resource;
    }

    public EmbeddedMultimapCache<WrappedByteArray, WrappedByteArray> multimap() {
        return (EmbeddedMultimapCache)this.resource;
    }

    private static long toMillis(ExpirationParam param) {
        if (param.duration > 0L) {
            long milliseconds = param.unit.toTimeUnit().toMillis(param.duration);
            if (milliseconds > MillisecondsIn30days) {
                long unixTimeExpiry = milliseconds - System.currentTimeMillis();
                return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
            }
            return milliseconds;
        }
        return param.duration;
    }

    static class RequestParameters {
        final int valueLength;
        final ExpirationParam lifespan;
        final ExpirationParam maxIdle;
        final long streamVersion;

        RequestParameters(int valueLength, ExpirationParam lifespan, ExpirationParam maxIdle, long streamVersion) {
            this.valueLength = valueLength;
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
            this.streamVersion = streamVersion;
        }

        public String toString() {
            return "RequestParameters{valueLength=" + this.valueLength + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", streamVersion=" + this.streamVersion + '}';
        }
    }

    static class ExpirationParam {
        final long duration;
        final TimeUnitValue unit;

        ExpirationParam(long duration, TimeUnitValue unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public String toString() {
            return "ExpirationParam{duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }
}

