/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.tx.ServerTransactionTable;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.transaction.impl.TransactionTable;

abstract class TransactionDecodeContext {
    final XidImpl xid;
    final ServerTransactionTable serverTransactionTable;
    final RpcManager rpcManager;
    final Address localAddress;
    final TransactionTable transactionTable;
    final CommandsFactory commandsFactory;
    private final ClusteringDependentLogic clusteringDependentLogic;
    TxState txState;

    TransactionDecodeContext(AdvancedCache<byte[], byte[]> cache, XidImpl xid) {
        this.xid = xid;
        this.rpcManager = cache.getRpcManager();
        this.localAddress = this.rpcManager != null ? this.rpcManager.getAddress() : null;
        ComponentRegistry registry = cache.getComponentRegistry();
        this.commandsFactory = registry.getCommandsFactory();
        this.transactionTable = (TransactionTable)registry.getComponent(TransactionTable.class);
        this.clusteringDependentLogic = (ClusteringDependentLogic)registry.getComponent(ClusteringDependentLogic.class);
        this.serverTransactionTable = (ServerTransactionTable)registry.getComponent(ServerTransactionTable.class);
        this.txState = this.serverTransactionTable.getGlobalState(xid);
    }

    public final TxState getTxState() {
        return this.txState;
    }

    public final boolean isAlive(Address address) {
        return this.clusteringDependentLogic.getCacheTopology().getActualMembers().contains(address);
    }

    public final void rollbackRemoteTransaction() {
        try {
            RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(this.txState.getGlobalTransaction());
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)rollbackCommand, this.rpcManager.getDefaultRpcOptions(true));
            this.commandsFactory.initializeReplicableCommand((ReplicableCommand)rollbackCommand, false);
            rollbackCommand.invokeAsync().join();
        }
        catch (Throwable throwable) {
            throw Util.rewrapAsCacheException((Throwable)throwable);
        }
        finally {
            this.forgetTransaction();
        }
    }

    final void advance(TxState update) {
        if (update == null || !this.serverTransactionTable.updateGlobalState(this.xid, this.txState, update)) {
            throw new IllegalStateException();
        }
        this.txState = update;
    }

    final void forgetTransaction() {
        TxCompletionNotificationCommand cmd = this.commandsFactory.buildTxCompletionNotificationCommand((Xid)this.xid, this.txState.getGlobalTransaction());
        this.rpcManager.sendToAll((ReplicableCommand)cmd, DeliverOrder.NONE);
        this.serverTransactionTable.removeGlobalState(this.xid);
    }

    final boolean isLocalMode() {
        return this.rpcManager == null;
    }
}

