/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

public class ConditionalMarkAsRollbackFunction
extends TxFunction {
    public static final AdvancedExternalizer<ConditionalMarkAsRollbackFunction> EXTERNALIZER = new Externalizer();
    private final byte expectStatus;

    public ConditionalMarkAsRollbackFunction(Status expected) {
        this(expected.value);
    }

    private ConditionalMarkAsRollbackFunction(byte expectStatus) {
        this.expectStatus = expectStatus;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            if (state.getStatus().value == this.expectStatus) {
                view.set((Object)state.setStatus(Status.MARK_ROLLBACK, true, this.timeService), new MetaParam.Writable[0]);
                return Status.OK.value;
            }
            return Status.ERROR.value;
        }
        return Status.NO_TRANSACTION.value;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ConditionalMarkAsRollbackFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends ConditionalMarkAsRollbackFunction>> getTypeClasses() {
            return Collections.singleton(ConditionalMarkAsRollbackFunction.class);
        }

        public Integer getId() {
            return 1122;
        }

        public void writeObject(ObjectOutput output, ConditionalMarkAsRollbackFunction object) throws IOException {
            output.writeByte(object.expectStatus);
        }

        public ConditionalMarkAsRollbackFunction readObject(ObjectInput input) throws IOException {
            return new ConditionalMarkAsRollbackFunction(input.readByte());
        }
    }
}

