/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedMetadataBuilder;

class MemcachedExpirableMetadata
extends MemcachedMetadata {
    protected final long lifespanTime;
    protected final TimeUnit lifespanUnit;

    MemcachedExpirableMetadata(long flags, EntryVersion version, long lifespanTime, TimeUnit lifespanUnit) {
        super(flags, version);
        this.lifespanTime = lifespanTime;
        this.lifespanUnit = Objects.requireNonNull(lifespanUnit);
    }

    @Override
    public long lifespan() {
        return this.lifespanUnit.toMillis(this.lifespanTime);
    }

    @Override
    public Metadata.Builder builder() {
        return new MemcachedMetadataBuilder().flags(this.flags).version(this.version).lifespan(this.lifespanTime, this.lifespanUnit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemcachedExpirableMetadata that = (MemcachedExpirableMetadata)o;
        if (this.lifespanTime != that.lifespanTime) {
            return false;
        }
        return this.lifespanUnit == that.lifespanUnit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.lifespanTime ^ this.lifespanTime >>> 32);
        result = 31 * result + this.lifespanUnit.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MemcachedExpirableMetadata{flags=" + this.flags + ", version=" + this.version + ", lifespanTime=" + this.lifespanTime + ", lifespanUnit=" + (Object)((Object)this.lifespanUnit) + "} ";
    }
}

