/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.tx;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;

public final class TransactionContext {
    private static final AttributeKey<Boolean> TRANSACTIONAL_CONTEXT = AttributeKey.newInstance((String)"multi-exec");

    private TransactionContext() {
    }

    public static void startTransactionContext(ChannelHandlerContext ctx) {
        Boolean existing = (Boolean)ctx.channel().attr(TRANSACTIONAL_CONTEXT).setIfAbsent((Object)Boolean.TRUE);
        if (existing != null) {
            throw new IllegalStateException("Nested transaction context");
        }
    }

    public static void endTransactionContext(ChannelHandlerContext ctx) {
        Boolean existing = (Boolean)ctx.channel().attr(TRANSACTIONAL_CONTEXT).getAndSet(null);
        if (existing == null) {
            throw new IllegalStateException("Not transaction context to remove");
        }
    }

    public static boolean isInTransactionContext(ChannelHandlerContext ctx) {
        return Boolean.TRUE.equals(ctx.channel().attr(TRANSACTIONAL_CONTEXT).get());
    }
}

