/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration.builder;

import org.infinispan.server.router.configuration.RouterConfiguration;
import org.infinispan.server.router.configuration.builder.ConfigurationBuilderParent;
import org.infinispan.server.router.configuration.builder.HotRodRouterBuilder;
import org.infinispan.server.router.configuration.builder.RestRouterBuilder;
import org.infinispan.server.router.configuration.builder.RoutingBuilder;
import org.infinispan.server.router.configuration.builder.SinglePortRouterBuilder;

public class RouterConfigurationBuilder
implements ConfigurationBuilderParent {
    private final RoutingBuilder routingBuilder = new RoutingBuilder(this);
    private final HotRodRouterBuilder hotRodRouterBuilder = new HotRodRouterBuilder(this);
    private final RestRouterBuilder restRouterBuilder = new RestRouterBuilder(this);
    private final SinglePortRouterBuilder singlePortRouterBuilder = new SinglePortRouterBuilder(this);

    @Override
    public RoutingBuilder routing() {
        return this.routingBuilder;
    }

    @Override
    public HotRodRouterBuilder hotrod() {
        this.hotRodRouterBuilder.enabled(true);
        return this.hotRodRouterBuilder;
    }

    @Override
    public RestRouterBuilder rest() {
        this.restRouterBuilder.enabled(true);
        return this.restRouterBuilder;
    }

    @Override
    public SinglePortRouterBuilder singlePort() {
        this.singlePortRouterBuilder.enabled(true);
        return this.singlePortRouterBuilder;
    }

    public RouterConfiguration build() {
        return new RouterConfiguration(this.routingBuilder.build(), this.hotRodRouterBuilder.build(), this.restRouterBuilder.build(), this.singlePortRouterBuilder.build());
    }
}

