/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.util.ReloadingX509TrustManager;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.security.KeyStoreUtils;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.SSLContextBuilder;

public class TrustStoreConfiguration
extends ConfigurationElement<TrustStoreConfiguration> {
    static final AttributeDefinition<Supplier<CredentialSource>> PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, Supplier.class).serializer((AttributeSerializer)ServerConfigurationSerializer.CREDENTIAL).build();
    static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    static final AttributeDefinition<String> PROVIDER = AttributeDefinition.builder((Enum)Attribute.PROVIDER, null, String.class).build();
    static final AttributeDefinition<String> TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, null, String.class).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TrustStoreConfiguration.class, new AttributeDefinition[]{PATH, RELATIVE_TO, PROVIDER, PASSWORD, TYPE});
    }

    TrustStoreConfiguration(AttributeSet attributes) {
        super((Enum)Element.TRUSTSTORE, attributes, new ConfigurationElement[0]);
    }

    KeyStore trustStore(Provider[] providers, Properties properties) {
        KeyStore keyStore;
        String fileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get()));
        String providerName = (String)this.attributes.attribute(PROVIDER).get();
        String type = (String)this.attributes.attribute(TYPE).get();
        if (fileName == null) {
            try {
                return KeyStoreUtils.buildFilelessKeyStore(providers, providerName, type);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new CacheConfigurationException(e);
            }
        }
        char[] password = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(PASSWORD));
        FileInputStream is = new FileInputStream(fileName);
        try {
            keyStore = KeyStoreUtil.loadKeyStore(() -> providers, (String)providerName, (FileInputStream)is, (String)fileName, (char[])password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException e) {
                throw new CacheConfigurationException(e);
            }
        }
        is.close();
        return keyStore;
    }

    public void build(SSLContextBuilder builder, Properties properties) {
        if (this.attributes.isModified()) {
            X509ExtendedTrustManager trustManager;
            Provider[] providers = SslContextFactory.discoverSecurityProviders((ClassLoader)Thread.currentThread().getContextClassLoader());
            if (this.attributes.attribute(PATH).isNull()) {
                try {
                    String providerName = (String)this.attributes.attribute(PROVIDER).get();
                    String type = (String)this.attributes.attribute(TYPE).get();
                    KeyStore keyStore = KeyStoreUtils.buildFilelessKeyStore(providers, providerName, type);
                    trustManager = this.trustManagerFromStore(keyStore, providers, providerName);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            } else {
                String providerName = (String)this.attributes.attribute(PROVIDER).get();
                String keyStoreFileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get()));
                FileWatcher watcher = (FileWatcher)properties.get("infinispan.file.watcher");
                if (watcher == null) {
                    try {
                        trustManager = this.trustManagerFromStore(this.trustStore(providers, properties), providers, providerName);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    trustManager = new ReloadingX509TrustManager(watcher, Paths.get(keyStoreFileName, new String[0]), p -> {
                        try {
                            return this.trustManagerFromStore(this.trustStore(providers, properties), providers, providerName);
                        }
                        catch (GeneralSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            builder.setTrustManager((X509TrustManager)trustManager);
        }
    }

    private X509ExtendedTrustManager trustManagerFromStore(KeyStore keyStore, Provider[] providers, String providerName) throws GeneralSecurityException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        Provider provider = ProviderUtil.findProvider((Provider[])providers, (String)providerName, KeyManagerFactory.class, (String)algorithm);
        TrustManagerFactory trustManagerFactory = provider != null ? TrustManagerFactory.getInstance(algorithm, provider) : TrustManagerFactory.getInstance(algorithm);
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)trustManager;
        }
        throw Server.log.noDefaultTrustManager();
    }
}

