/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6.jpa;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    PERSISTENCE_UNIT_NAME("persistenceUnitName"),
    ENTITY_CLASS_NAME("entityClassName"),
    BATCH_SIZE("batchSize"),
    STORE_METADATA("storeMetadata");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

