/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import java.util.List;
import org.influxdb.dto.ContinuousQuery;
import org.influxdb.dto.Database;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Serie;
import org.influxdb.dto.Server;
import org.influxdb.dto.Shard;
import org.influxdb.dto.Shards;
import org.influxdb.dto.User;
import org.influxdb.impl.DELETE;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;

interface InfluxDBService {
    @GET(value="/ping")
    public Pong ping();

    @GET(value="/interfaces")
    public Response version();

    @POST(value="/db")
    public String createDatabase(@Body Database var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @retrofit.http.DELETE(value="/db/{name}")
    public String deleteDatabase(@Path(value="name") String var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @GET(value="/db")
    public List<Database> describeDatabases(@Query(value="u") String var1, @Query(value="p") String var2);

    @POST(value="/db/{name}/series")
    public String write(@Path(value="name") String var1, @Body Serie[] var2, @Query(value="u") String var3, @Query(value="p") String var4, @Query(value="time_precision") String var5);

    @GET(value="/db/{name}/series")
    public List<Serie> query(@Path(value="name") String var1, @Query(value="q") String var2, @Query(value="u") String var3, @Query(value="p") String var4, @Query(value="time_precision") String var5);

    @POST(value="/cluster_admins")
    public String createClusterAdmin(@Body User var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @retrofit.http.DELETE(value="/cluster_admins/{name}")
    public String deleteClusterAdmin(@Path(value="name") String var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @GET(value="/cluster_admins")
    public List<User> describeClusterAdmins(@Query(value="u") String var1, @Query(value="p") String var2);

    @POST(value="/cluster_admins/{name}")
    public String updateClusterAdmin(@Body User var1, @Path(value="name") String var2, @Query(value="u") String var3, @Query(value="p") String var4);

    @POST(value="/db/{database}/users")
    public String createDatabaseUser(@Path(value="database") String var1, @Body User var2, @Query(value="u") String var3, @Query(value="p") String var4);

    @retrofit.http.DELETE(value="/db/{database}/users/{name}")
    public String deleteDatabaseUser(@Path(value="database") String var1, @Path(value="name") String var2, @Query(value="u") String var3, @Query(value="p") String var4);

    @GET(value="/db/{database}/users")
    public List<User> describeDatabaseUsers(@Path(value="database") String var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @POST(value="/db/{database}/users/{name}")
    public String updateDatabaseUser(@Path(value="database") String var1, @Body User var2, @Path(value="name") String var3, @Query(value="u") String var4, @Query(value="p") String var5);

    @GET(value="/db/{database}/authenticate")
    public String authenticateDatabaseUser(@Path(value="database") String var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @GET(value="/db/{database}/continuous_queries")
    public List<ContinuousQuery> getContinuousQueries(@Path(value="database") String var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @retrofit.http.DELETE(value="/db/{database}/continuous_queries/{id}")
    public String deleteContinuousQuery(@Path(value="database") String var1, @Path(value="id") int var2, @Query(value="u") String var3, @Query(value="p") String var4);

    @retrofit.http.DELETE(value="/db/{database}/series/{name}")
    public String deletePoints(@Path(value="database") String var1, @Path(value="name") String var2, @Query(value="u") String var3, @Query(value="p") String var4);

    @POST(value="/raft/force_compaction")
    public String forceRaftCompaction(@Query(value="u") String var1, @Query(value="p") String var2);

    @GET(value="/interfaces")
    public List<String> interfaces(@Query(value="u") String var1, @Query(value="p") String var2);

    @GET(value="/sync")
    public Boolean sync(@Query(value="u") String var1, @Query(value="p") String var2);

    @GET(value="/cluster/servers")
    public List<Server> listServers(@Query(value="u") String var1, @Query(value="p") String var2);

    @retrofit.http.DELETE(value="/cluster/servers/{id}")
    public String removeServers(@Path(value="id") int var1, @Query(value="u") String var2, @Query(value="p") String var3);

    @POST(value="/cluster/shards")
    public String createShard(@Query(value="u") String var1, @Query(value="p") String var2, @Body Shard var3);

    @GET(value="/cluster/shards")
    public Shards getShards(@Query(value="u") String var1, @Query(value="p") String var2);

    @DELETE(value="/cluster/shards/{id}")
    public String dropShard(@Path(value="id") int var1, @Query(value="u") String var2, @Query(value="p") String var3, @Body Shard.Member var4);
}

