/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.instancio.TypeTokenSupplier;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.Generator;
import org.instancio.internal.ApiValidatorMessageHelper;
import org.instancio.internal.GeneratorSupport;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.SettingKey;
import org.jetbrains.annotations.Nullable;

public final class ApiValidator {
    private static final String CREATE_TYPE_TOKEN_HELP = "%nMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%nor the builder version:%n%nMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();";
    private static final String CREATE_CLASS_HELP = "%nPerson person = Instancio.create(Person.class);%n%nor the builder version:%n%nPerson person = Instancio.of(Person.class).create();";

    public static <T> Class<T> validateRootClass(@Nullable Class<T> klass) {
        ApiValidator.isTrue(klass != null, "%nClass must not be null.%nProvide a valid class, for example:%n%nPerson person = Instancio.create(Person.class);%n%nor the builder version:%n%nPerson person = Instancio.of(Person.class).create();", new Object[0]);
        return klass;
    }

    public static Type validateTypeToken(@Nullable TypeTokenSupplier<?> typeTokenSupplier) {
        ApiValidator.isTrue(typeTokenSupplier != null, "%nType token supplier must not be null.%nProvide a valid type token, for example:%n%nMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%nor the builder version:%n%nMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();", new Object[0]);
        Type type = typeTokenSupplier.get();
        ApiValidator.isTrue(type != null, "%nType token supplier must not return a null Type.%nProvide a valid Type, for example:%n%nMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%nor the builder version:%n%nMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();", new Object[0]);
        return type;
    }

    public static void validateTypeParameters(Class<?> rootClass, List<Class<?>> rootTypeParameters) {
        int typeVarsLength;
        int n = typeVarsLength = rootClass.isArray() ? rootClass.getComponentType().getTypeParameters().length : rootClass.getTypeParameters().length;
        if (typeVarsLength == 0 && !rootTypeParameters.isEmpty()) {
            throw new InstancioApiException(ApiValidatorMessageHelper.withTypeParametersNonGenericClass(rootClass));
        }
        ApiValidator.isTrue(typeVarsLength == rootTypeParameters.size(), ApiValidatorMessageHelper.withTypeParametersNumberOfParameters(rootClass, rootTypeParameters), new Object[0]);
        for (Class<?> param : rootTypeParameters) {
            if (param.getTypeParameters().length <= 0) continue;
            String classWithTypeParams = String.format("%s<%s>", param.getSimpleName(), Format.getTypeVariablesCsv(param));
            throw new InstancioApiException(ApiValidatorMessageHelper.withTypeParametersNestedGenerics(classWithTypeParams));
        }
    }

    public static void validateSubtype(Class<?> from, Class<?> to) {
        ApiValidator.isTrue(from.isAssignableFrom(to), () -> String.format("Class '%s' is not a subtype of '%s'", to.getTypeName(), from.getTypeName()));
        ApiValidator.isFalse(from.equals(to), () -> String.format("Invalid subtype mapping from '%s' to '%s'", to.getTypeName(), from.getTypeName()));
    }

    public static void validateKeyValue(@Nullable SettingKey<?> key, @Nullable Object value) {
        ApiValidator.isTrue(key != null, "Setting key must not be null", new Object[0]);
        if (!key.allowsNullValue()) {
            ApiValidator.isTrue(value != null, "Setting value for key '%s' must not be null", key);
        }
        if (value != null) {
            ApiValidator.isTrue(key.type() == value.getClass(), () -> String.format("The value '%s' is of unexpected type (%s) for key '%s' (expected: %s)", value, value.getClass().getSimpleName(), key, key.type().getSimpleName()));
        }
    }

    public static <T> T[] notEmpty(@Nullable T[] array, String message, Object ... values) {
        ApiValidator.isTrue(array != null && array.length > 0, message, values);
        return array;
    }

    public static <T> Collection<T> notEmpty(@Nullable Collection<T> collection, String message, Object ... values) {
        ApiValidator.isTrue(collection != null && !collection.isEmpty(), message, values);
        return collection;
    }

    public static void validateGeneratorUsage(InternalNode node, Generator<?> generator) {
        AbstractGenerator<?> absGen = GeneratorSupport.unpackGenerator(generator);
        if (absGen == null) {
            return;
        }
        String name = absGen.apiMethod();
        if (name != null) {
            ApiValidator.isTrue(GeneratorSupport.supports(absGen, node.getTargetClass()), () -> String.format(ApiValidator.generateMismatchErrorMessageTemplate(node, name), new Object[0]));
        }
    }

    private static String generateMismatchErrorMessageTemplate(InternalNode node, String apiMethodName) {
        return "%nGenerator type mismatch:%nMethod '" + apiMethodName + "' cannot be used for type: " + node.getTargetClass().getCanonicalName() + (node.getField() == null ? "" : "%nField: " + node.getField());
    }

    public static void validateGenerateSecondArgument(Object arg) {
        ApiValidator.isFalse(arg == null, () -> String.format("%nThe second argument of 'generate()' method must not be null.%nTo generate a null value, use 'set(TargetSelector, null)%nExample:%n\tPerson person = Instancio.of(Person.class)%n\t\t.set(field(\"firstName\"), null)%n\t\t.create()", new Object[0]));
    }

    public static void validateSupplierOrGenerator(@Nullable Object obj) {
        ApiValidator.isFalse(obj == null, () -> String.format("%nThe second argument of 'supply()' method must not be null.%nTo generate a null value, use 'set(TargetSelector, null)%nExample:%n\tPerson person = Instancio.of(Person.class)%n\t\t.set(field(\"firstName\"), null)%n\t\t.create()", new Object[0]));
    }

    public static int validateSize(int size) {
        ApiValidator.isTrue(size >= 0, "Size must not be negative: %s", size);
        return size;
    }

    public static int validateLength(int length) {
        ApiValidator.isTrue(length >= 0, "Length must not be negative: %s", length);
        return length;
    }

    public static <T> T notNull(@Nullable T obj, String message, Object ... values) {
        if (obj == null) {
            throw new InstancioApiException(String.format(message, values));
        }
        return obj;
    }

    public static <T> T notNull(@Nullable T obj, Supplier<String> supplier) {
        if (obj == null) {
            throw new InstancioApiException(supplier.get());
        }
        return obj;
    }

    public static void isTrue(boolean condition, String message, Object ... values) {
        if (!condition) {
            throw new InstancioApiException(String.format(message, values));
        }
    }

    public static void isFalse(boolean condition, String message, Object ... values) {
        if (condition) {
            throw new InstancioApiException(String.format(message, values));
        }
    }

    private static void isTrue(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new InstancioApiException(message.get());
        }
    }

    public static void isFalse(boolean condition, Supplier<String> message) {
        if (condition) {
            throw new InstancioApiException(message.get());
        }
    }

    public static void validateField(Class<?> declaringClass, String fieldName, String message) {
        ApiValidator.notNull(declaringClass, message, new Object[0]);
        ApiValidator.notNull(fieldName, message, new Object[0]);
        ApiValidator.isTrue(ReflectionUtils.isValidField(declaringClass, fieldName), message, new Object[0]);
    }

    private ApiValidator() {
    }
}

