/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.hibernate.validator.constraints.UniqueElements;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.DurationGeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.FieldAnnotationHandler;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.util.BeanValidationUtils;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.IntRange;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;

final class HibernateBeanValidationHandlerResolver
implements AnnotationHandlerResolver {
    private final Map<Class<?>, FieldAnnotationHandler> handlerMap = HibernateBeanValidationHandlerResolver.initHandlers();

    private HibernateBeanValidationHandlerResolver() {
    }

    static HibernateBeanValidationHandlerResolver getInstance() {
        return Holder.INSTANCE;
    }

    private static Map<Class<?>, FieldAnnotationHandler> initHandlers() {
        HashMap map = new HashMap();
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(DurationMin.class, new DurationMinHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(DurationMax.class, new DurationMaxHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Length.class, new LengthHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Range.class, new RangeHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(UniqueElements.class, new UniqueElementsHandler()));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public FieldAnnotationHandler resolveHandler(Annotation annotation) {
        return this.handlerMap.get(annotation.annotationType());
    }

    private static class Holder {
        private static final HibernateBeanValidationHandlerResolver INSTANCE = new HibernateBeanValidationHandlerResolver();

        private Holder() {
        }
    }

    private static class UniqueElementsHandler
    implements FieldAnnotationHandler {
        private UniqueElementsHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof CollectionGeneratorSpec) {
                ((CollectionGeneratorSpec)spec).unique();
            }
        }
    }

    private static class RangeHandler
    implements FieldAnnotationHandler {
        private RangeHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Range range = (Range)annotation;
            if (spec instanceof NumberGeneratorSpec) {
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                AbstractRandomNumberGeneratorSpec numSpec = (AbstractRandomNumberGeneratorSpec)spec;
                numSpec.min((Number)fromLongConverter.apply(range.min())).max((Number)fromLongConverter.apply(range.max()));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            } else if (spec instanceof StringGenerator) {
                StringGenerator stringGenerator = (StringGenerator)spec;
                LongGenerator numGenerator = new LongGenerator(stringGenerator.getContext()).nullable(false).min(range.min()).max(range.max());
                stringGenerator.setDelegate(numGenerator);
            }
        }
    }

    private static class LengthHandler
    implements FieldAnnotationHandler {
        private LengthHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Length length = (Length)annotation;
            IntRange range = BeanValidationUtils.calculateRange(length.min(), length.max(), Keys.STRING_MAX_LENGTH.defaultValue());
            if (spec instanceof StringGeneratorSpec) {
                StringGeneratorSpec stringSpec = (StringGeneratorSpec)spec;
                stringSpec.length(range.min(), range.max());
                if (range.min() > 0) {
                    stringSpec.allowEmpty(false);
                }
            }
        }
    }

    private static class DurationMaxHandler
    implements FieldAnnotationHandler {
        private DurationMaxHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof DurationGeneratorSpec) {
                DurationMax d = (DurationMax)annotation;
                Duration max = Duration.ofDays(d.days()).plusHours(d.hours()).plusMinutes(d.minutes()).plusSeconds(d.seconds()).plusMillis(d.millis()).plusNanos(d.nanos());
                DurationGeneratorSpec durationSpec = (DurationGeneratorSpec)spec;
                durationSpec.max(max.toNanos(), ChronoUnit.NANOS);
            }
        }
    }

    private static class DurationMinHandler
    implements FieldAnnotationHandler {
        private DurationMinHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof DurationGeneratorSpec) {
                DurationMin d = (DurationMin)annotation;
                Duration min = Duration.ofDays(d.days()).plusHours(d.hours()).plusMinutes(d.minutes()).plusSeconds(d.seconds()).plusMillis(d.millis()).plusNanos(d.nanos());
                DurationGeneratorSpec durationSpec = (DurationGeneratorSpec)spec;
                durationSpec.min(min.toNanos(), ChronoUnit.NANOS);
            }
        }
    }
}

