/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import org.instancio.exception.InstancioException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.spi.InstancioSpiException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GeneratorUtil {
    private GeneratorUtil() {
    }

    @Nullable
    static Generator<?> instantiateInternalGenerator(@NotNull Class<?> generatorClass, @NotNull GeneratorContext context) {
        try {
            Constructor<?> constructor = generatorClass.getConstructor(GeneratorContext.class);
            return (Generator)constructor.newInstance(context);
        }
        catch (Exception ex) {
            ExceptionHandler.conditionalFailOnError(() -> {
                throw new InstancioException("Error instantiating generator " + generatorClass, ex);
            });
            return null;
        }
    }

    @NotNull
    static Generator<?> instantiateSpiGenerator(@NotNull Class<?> generatorClass, @NotNull GeneratorContext context) {
        Constructor<?> constructor = GeneratorUtil.getConstructor(generatorClass);
        if (constructor == null) {
            throw new InstancioSpiException(String.format("%nGenerator class:%n -> %s%ndoes not define any of the expected constructors:%n -> constructor with GeneratorContext as the only argument, or%n -> default no-argument constructor", generatorClass.getName()));
        }
        try {
            Object[] objectArray;
            constructor.setAccessible(true);
            if (constructor.getParameterCount() == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = context;
            } else {
                objectArray = new Object[]{};
            }
            Object[] args = objectArray;
            return (Generator)constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new InstancioSpiException("Error instantiating generator " + generatorClass, ex);
        }
    }

    @Nullable
    static Constructor<?> getConstructor(@NotNull Class<?> generatorClass) {
        Constructor<?>[] constructors = generatorClass.getDeclaredConstructors();
        Constructor<?> defaultCtor = null;
        for (Constructor<?> ctor : constructors) {
            Parameter[] params = ctor.getParameters();
            if (params.length == 0) {
                defaultCtor = ctor;
                continue;
            }
            if (params.length != 1 || params[0].getType() != GeneratorContext.class) continue;
            return ctor;
        }
        return defaultCtor;
    }
}

