/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.CharacterAsGeneratorSpec;
import org.instancio.generator.specs.CharacterSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.settings.Keys;
import org.instancio.support.Global;

public class CharacterGenerator
extends AbstractGenerator<Character>
implements CharacterSpec,
CharacterAsGeneratorSpec {
    private char min = (char)65;
    private char max = (char)90;

    public CharacterGenerator(GeneratorContext context) {
        super(context);
        super.nullable(context.getSettings().get(Keys.CHARACTER_NULLABLE));
    }

    public CharacterGenerator() {
        this(Global.generatorContext());
    }

    @Override
    public String apiMethod() {
        return "chars()";
    }

    @Override
    public CharacterGenerator range(char min, char max) {
        ApiValidator.isTrue(min <= max, "Invalid 'range(%s, %s)': lower bound must be less than or equal to upper bound", Character.valueOf(min), Character.valueOf(max));
        this.min = min;
        this.max = max;
        return this;
    }

    @Override
    public CharacterGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Character tryGenerateNonNull(Random random) {
        return Character.valueOf(random.characterRange(this.min, this.max));
    }
}

