/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.util.Locale;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.UUIDStringSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.support.Global;

public class UUIDStringGenerator
extends AbstractGenerator<String>
implements UUIDStringSpec {
    private boolean isUpperCase;
    private boolean isWithoutDashes;
    private final UUIDGenerator delegate;

    public UUIDStringGenerator() {
        this(Global.generatorContext());
    }

    public UUIDStringGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new UUIDGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "uuid()";
    }

    @Override
    public UUIDStringGenerator upperCase() {
        this.isUpperCase = true;
        return this;
    }

    @Override
    public UUIDStringGenerator withoutDashes() {
        this.isWithoutDashes = true;
        return this;
    }

    @Override
    public UUIDStringGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String uuid = this.delegate.tryGenerateNonNull(random).toString();
        if (this.isUpperCase) {
            uuid = uuid.toUpperCase(Locale.ROOT);
        }
        if (this.isWithoutDashes) {
            uuid = uuid.replace("-", "");
        }
        return uuid;
    }
}

