/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.ObjectUtils;

class LeastArgumentsConstructorInstantiationStrategy
implements InstantiationStrategy {
    LeastArgumentsConstructorInstantiationStrategy() {
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        Optional<Constructor> optCtor = Arrays.stream(klass.getDeclaredConstructors()).filter(c -> c.getParameterCount() > 0).min(Comparator.comparingInt(Constructor::getParameterCount));
        if (!optCtor.isPresent()) {
            return null;
        }
        Constructor constructor = optCtor.get();
        constructor.setAccessible(true);
        Parameter[] params = constructor.getParameters();
        Object[] args = new Object[params.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ObjectUtils.defaultValue(params[i].getType());
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            ExceptionHandler.logException("Error instantiating {} using {}", ex, klass, this.getClass().getSimpleName());
            return null;
        }
    }
}

