/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.TypeResolverFacade;
import org.instancio.internal.spi.InternalContainerFactoryProvider;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.spi.InstancioServiceProvider;

public final class NodeContext {
    private final int maxDepth;
    private final Map<TypeVariable<?>, Class<?>> rootTypeMap;
    private final BooleanSelectorMap ignoredSelectorMap;
    private final SubtypeSelectorMap subtypeSelectorMap;
    private final Map<Class<?>, Class<?>> subtypeMappingFromSettings;
    private final TypeResolverFacade typeResolverFacade;
    private final List<InternalContainerFactoryProvider> containerFactories;

    private NodeContext(Builder builder) {
        this.maxDepth = builder.maxDepth;
        this.rootTypeMap = builder.rootTypeMap;
        this.ignoredSelectorMap = builder.ignoredSelectorMap;
        this.subtypeSelectorMap = builder.subtypeSelectorMap;
        this.subtypeMappingFromSettings = builder.subtypeMappingFromSettings;
        this.containerFactories = builder.containerFactories;
        this.typeResolverFacade = new TypeResolverFacade(builder.providerEntries);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Map<TypeVariable<?>, Class<?>> getRootTypeMap() {
        return this.rootTypeMap;
    }

    Optional<Class<?>> getSubtype(@NotNull InternalNode node) {
        Optional<Class<?>> subtype = this.subtypeSelectorMap.getSubtype(node);
        if (subtype.isPresent()) {
            return subtype;
        }
        Class<?> subtypeFromSettings = this.subtypeMappingFromSettings.get(node.getRawType());
        return subtypeFromSettings == null ? this.typeResolverFacade.resolve(node.getRawType()) : Optional.of(subtypeFromSettings);
    }

    boolean isIgnored(@NotNull InternalNode node) {
        return this.ignoredSelectorMap.isTrue(node);
    }

    public List<InternalContainerFactoryProvider> getContainerFactories() {
        return this.containerFactories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int maxDepth;
        private Map<TypeVariable<?>, Class<?>> rootTypeMap = Collections.emptyMap();
        private BooleanSelectorMap ignoredSelectorMap;
        private SubtypeSelectorMap subtypeSelectorMap;
        private Map<Class<?>, Class<?>> subtypeMappingFromSettings = Collections.emptyMap();
        private List<InternalContainerFactoryProvider> containerFactories = Collections.emptyList();
        private List<ProviderEntry<InstancioServiceProvider.TypeResolver>> providerEntries = Collections.emptyList();

        private Builder() {
        }

        public Builder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder rootTypeMap(Map<TypeVariable<?>, Class<?>> rootTypeMap) {
            this.rootTypeMap = rootTypeMap;
            return this;
        }

        public Builder ignoredSelectorMap(BooleanSelectorMap ignoredSelectorMap) {
            this.ignoredSelectorMap = ignoredSelectorMap;
            return this;
        }

        public Builder subtypeSelectorMap(SubtypeSelectorMap subtypeSelectorMap) {
            this.subtypeSelectorMap = subtypeSelectorMap;
            return this;
        }

        public Builder subtypeMappingFromSettings(Map<Class<?>, Class<?>> subtypeMappingFromSettings) {
            this.subtypeMappingFromSettings = subtypeMappingFromSettings;
            return this;
        }

        public Builder containerFactories(List<InternalContainerFactoryProvider> containerFactories) {
            this.containerFactories = containerFactories;
            return this;
        }

        public Builder providerEntries(List<ProviderEntry<InstancioServiceProvider.TypeResolver>> providerEntries) {
            this.providerEntries = providerEntries;
            return this;
        }

        public NodeContext build() {
            return new NodeContext(this);
        }
    }
}

