/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.TypeUtils;

public final class TypeMap {
    private final Map<TypeVariable<?>, Class<?>> rootTypeMap;
    private final Map<Type, Type> typeMap;

    public TypeMap(Type genericType, Map<TypeVariable<?>, Class<?>> rootTypeMap) {
        this(genericType, rootTypeMap, Collections.emptyMap());
    }

    public TypeMap(Type genericType, Map<TypeVariable<?>, Class<?>> rootTypeMap, Map<Type, Type> subtypeMappingTypeMap) {
        this.rootTypeMap = Collections.unmodifiableMap(rootTypeMap);
        this.typeMap = Collections.unmodifiableMap(this.buildTypeMap(genericType, subtypeMappingTypeMap));
    }

    public Type get(Type type) {
        return this.typeMap.get(type);
    }

    public Type getOrDefault(Type type, Type defaultValue) {
        return this.typeMap.getOrDefault(type, defaultValue);
    }

    public Type getActualType(Type type) {
        return this.typeMap.get(type);
    }

    public int size() {
        return this.typeMap.size();
    }

    private Map<Type, Type> buildTypeMap(Type genericType, Map<Type, Type> subtypeMappingTypeMap) {
        HashMap<Type, Type> map = new HashMap<Type, Type>(subtypeMappingTypeMap);
        if (genericType instanceof Class) {
            return map;
        }
        if (genericType instanceof TypeVariable && this.rootTypeMap.containsKey(genericType)) {
            Class<?> mappedType = this.rootTypeMap.get(genericType);
            map.put(genericType, mappedType);
            return map;
        }
        if (genericType instanceof ParameterizedType) {
            Class rawType = TypeUtils.getRawType(genericType);
            Type[] typeArgs = TypeUtils.getTypeArguments(genericType);
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < typeArgs.length; ++i) {
                Type mappedType = this.resolveTypeMapping(typeArgs[i]);
                map.put(typeVars[i], ObjectUtils.defaultIfNull(mappedType, typeArgs[i]));
            }
        }
        return map;
    }

    private Type resolveTypeMapping(Type typeArg) {
        if (typeArg instanceof Class || typeArg instanceof ParameterizedType || typeArg instanceof GenericArrayType) {
            return typeArg;
        }
        if (typeArg instanceof TypeVariable) {
            return this.rootTypeMap.get(typeArg);
        }
        if (typeArg instanceof WildcardType) {
            WildcardType wType = (WildcardType)typeArg;
            return this.resolveTypeMapping(wType.getUpperBounds()[0]);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeArg.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeMap)) {
            return false;
        }
        TypeMap other = (TypeMap)o;
        return Objects.equals(this.rootTypeMap, other.rootTypeMap) && Objects.equals(this.typeMap, other.typeMap);
    }

    public int hashCode() {
        return Objects.hash(this.rootTypeMap, this.typeMap);
    }

    public String toString() {
        return new StringJoiner("\n - ", TypeMap.class.getSimpleName() + "[", "]").add("typeMap=" + this.typeMap).add("rootTypeMap=" + this.rootTypeMap).toString();
    }
}

