/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes.resolvers;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.nodes.resolvers.NodeKindArrayResolver;
import org.instancio.internal.nodes.resolvers.NodeKindCollectionResolver;
import org.instancio.internal.nodes.resolvers.NodeKindContainerResolver;
import org.instancio.internal.nodes.resolvers.NodeKindMapResolver;
import org.instancio.internal.nodes.resolvers.NodeKindRecordResolver;
import org.instancio.internal.spi.InternalContainerFactoryProvider;

public class NodeKindResolverFacade {
    private final NodeKindResolver[] resolvers;

    public NodeKindResolverFacade(List<InternalContainerFactoryProvider> containerFactories) {
        this.resolvers = new NodeKindResolver[]{new NodeKindCollectionResolver(), new NodeKindMapResolver(), new NodeKindArrayResolver(), new NodeKindRecordResolver(), new NodeKindContainerResolver(Collections.unmodifiableList(containerFactories))};
    }

    public NodeKind getNodeKind(Class<?> rawType) {
        for (NodeKindResolver resolver : this.resolvers) {
            Optional<NodeKind> resolve = resolver.resolve(rawType);
            if (!resolve.isPresent()) continue;
            return resolve.get();
        }
        return NodeKind.DEFAULT;
    }
}

