/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.instancio.GetMethodSelector;
import org.instancio.Select;
import org.instancio.Selector;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public final class MethodReferenceHelper {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private MethodReferenceHelper() {
    }

    public static <T, R> Selector resolve(GetMethodSelector<T, R> methodRef) {
        try {
            Method replaceMethod = methodRef.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            SerializedLambda lambda = (SerializedLambda)replaceMethod.invoke(methodRef, new Object[0]);
            String className = lambda.getImplClass().replace('/', '.');
            Class<?> targetClass = Class.forName(className);
            String fieldName = MethodReferenceHelper.getFieldNameDeclaredInClass(targetClass, lambda.getImplMethodName());
            if (fieldName == null) {
                throw new InstancioApiException(MethodReferenceHelper.getErrorMessage(lambda, targetClass));
            }
            return Select.field(targetClass, fieldName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new InstancioApiException("Unable to resolve method name from field selector", ex);
        }
    }

    private static String getErrorMessage(SerializedLambda lambda, Class<?> targetClass) {
        String at = Format.firstNonInstancioStackTraceLine(new Throwable());
        return new StringBuilder(1024).append(Constants.NL).append(Constants.NL).append("Unable to resolve the field from method reference:").append(Constants.NL).append("-> ").append(Format.withoutPackage(targetClass)).append("::").append(lambda.getImplMethodName()).append(Constants.NL).append("   at ").append(at).append(Constants.NL).append(Constants.NL).append("Potential causes:").append(Constants.NL).append("-> The method and the corresponding field do not follow expected naming conventions").append(Constants.NL).append("   See: https://www.instancio.org/user-guide/#method-reference-selector").append(Constants.NL).append("-> The method is abstract, declared in a superclass, and the field is declared in a subclass").append(Constants.NL).append("-> The method reference is expressed as a lambda function").append(Constants.NL).append("   Example:     field((SamplePojo pojo) -> pojo.getValue())").append(Constants.NL).append("   Instead of:  field(SamplePojo::getValue)").append(Constants.NL).append("-> You are using Kotlin and passing a method reference of a Kotlin class").append(Constants.NL).append(Constants.NL).append("Possible solutions:").append(Constants.NL).append("-> Resolve the above issues, if applicable").append(Constants.NL).append("-> Specify the field name explicitly, e.g.").append(Constants.NL).append("   field(Example.class, \"someField\")").append(Constants.NL).append("-> If using Kotlin, consider creating a 'KSelect' utility class, for example:").append(Constants.NL).append(Constants.NL).append("   class KSelect {").append(Constants.NL).append("       companion object {").append(Constants.NL).append("           fun <T, V> field(property: KProperty1<T, V>): TargetSelector {").append(Constants.NL).append("               val field = property.javaField!!").append(Constants.NL).append("               return Select.field(field.declaringClass, field.name)").append(Constants.NL).append("           }").append(Constants.NL).append("       }").append(Constants.NL).append("   }").append(Constants.NL).append(Constants.NL).append("   Usage: KSelect.field(SamplePojo::value)").toString();
    }

    @Nullable
    static String getFieldNameDeclaredInClass(Class<?> targetClass, String methodName) {
        String filedName;
        if (MethodReferenceHelper.hasPrefix(GET_PREFIX, methodName)) {
            String filedName2 = MethodReferenceHelper.getFieldNameByRemovingPrefix(targetClass, methodName, GET_PREFIX.length());
            if (filedName2 != null) {
                return filedName2;
            }
        } else if (MethodReferenceHelper.hasPrefix(IS_PREFIX, methodName) && (filedName = MethodReferenceHelper.getFieldNameByRemovingPrefix(targetClass, methodName, IS_PREFIX.length())) != null) {
            return filedName;
        }
        if (ReflectionUtils.isValidField(targetClass, methodName)) {
            return methodName;
        }
        return null;
    }

    @Nullable
    private static String getFieldNameByRemovingPrefix(Class<?> targetClass, String methodName, int getPrefixLength) {
        char[] ch = methodName.toCharArray();
        ch[getPrefixLength] = Character.toLowerCase(ch[getPrefixLength]);
        String filedName = new String(ch, getPrefixLength, ch.length - getPrefixLength);
        return ReflectionUtils.isValidField(targetClass, filedName) ? filedName : null;
    }

    private static boolean hasPrefix(String prefix, String methodName) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }
}

