/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import java.util.Objects;
import org.instancio.internal.settings.AutoAdjustable;
import org.instancio.internal.settings.RangeAdjuster;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalKey<T>
implements SettingKey<T>,
AutoAdjustable,
Comparable<SettingKey<T>> {
    private final String propertyKey;
    private final Class<?> type;
    private final Object defaultValue;
    private final RangeAdjuster rangeAdjuster;
    private final boolean allowsNullValue;

    public InternalKey(String propertyKey, Class<?> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNullValue) {
        this.propertyKey = propertyKey;
        this.type = type;
        this.defaultValue = defaultValue;
        this.rangeAdjuster = rangeAdjuster;
        this.allowsNullValue = allowsNullValue;
    }

    @Override
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public T defaultValue() {
        return (T)this.defaultValue;
    }

    @Override
    public boolean allowsNullValue() {
        return this.allowsNullValue;
    }

    @Override
    public <N extends Number> void autoAdjust(@NotNull Settings settings, @NotNull N otherValue) {
        if (this.rangeAdjuster != null) {
            InternalKey key = this;
            this.rangeAdjuster.adjustRange(settings, key, otherValue);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalKey)) {
            return false;
        }
        InternalKey key = (InternalKey)o;
        return Objects.equals(this.propertyKey, key.propertyKey);
    }

    public int hashCode() {
        return Objects.hash(this.propertyKey);
    }

    @Override
    public int compareTo(SettingKey<T> o) {
        return this.propertyKey.compareTo(o.propertyKey());
    }

    public String toString() {
        return this.propertyKey;
    }
}

