/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.Verify;

public final class LuhnUtils {
    private LuhnUtils() {
    }

    public static boolean isLuhnValid(String s) {
        return LuhnUtils.isLuhnValid(0, s.length() - 1, s.length() - 1, s);
    }

    public static boolean isLuhnValid(int startIdx, int endIdx, int checkIdx, String s) {
        Verify.isTrue(checkIdx >= 0 && (checkIdx < startIdx || checkIdx >= endIdx), "Invalid check digit index %s for range (%s, %s)", checkIdx, startIdx, endIdx);
        char[] payload = s.substring(startIdx, endIdx + 1).toCharArray();
        int expectedCheckDigit = LuhnUtils.getCheckDigit(payload);
        int checkDigit = s.charAt(checkIdx) - 48;
        return checkDigit == expectedCheckDigit;
    }

    public static int getCheckDigit(char[] payload) {
        int parity = payload.length % 2;
        int sum = 0;
        for (int i = 0; i < payload.length - 1; ++i) {
            int n = payload[i] - 48;
            int doubled = i % 2 == parity ? n * 2 : n;
            int doubledSum = NumberUtils.sumDigits(NumberUtils.sumDigits(doubled));
            sum += doubledSum;
        }
        return (10 - sum % 10) % 10;
    }
}

