/*
 * Decompiled with CFR 0.152.
 */
package org.instancio;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.instancio.InstancioApi;
import org.instancio.InstancioOfClassApi;
import org.instancio.InstancioOfCollectionApi;
import org.instancio.Model;
import org.instancio.TypeTokenSupplier;
import org.instancio.internal.ApiImpl;
import org.instancio.internal.OfClassApiImpl;
import org.instancio.internal.OfCollectionApiImpl;
import org.instancio.internal.OfMapApiImpl;

public final class Instancio {
    private Instancio() {
    }

    public static <T> T create(Class<T> type) {
        return Instancio.of(type).create();
    }

    public static <T> Stream<T> stream(Class<T> type) {
        return Instancio.of(type).stream();
    }

    public static <T> T create(TypeTokenSupplier<T> typeToken) {
        return Instancio.of(typeToken).create();
    }

    public static <T> Stream<T> stream(TypeTokenSupplier<T> typeToken) {
        return Instancio.of(typeToken).stream();
    }

    public static <T> T create(Model<T> model) {
        return Instancio.of(model).create();
    }

    public static <T> Stream<T> stream(Model<T> model) {
        return Instancio.of(model).stream();
    }

    public static <T> InstancioOfClassApi<T> of(Class<T> type) {
        return new OfClassApiImpl<T>(type);
    }

    public static <T> InstancioApi<T> of(TypeTokenSupplier<T> typeToken) {
        return new ApiImpl<T>(typeToken);
    }

    public static <T> InstancioApi<T> of(Model<T> model) {
        return new ApiImpl<T>(model);
    }

    public static <T> InstancioOfCollectionApi<List<T>> ofList(Class<T> elementType) {
        return new OfCollectionApiImpl<T, List>(List.class, elementType);
    }

    public static <T> InstancioOfCollectionApi<List<T>> ofList(Model<T> elementModel) {
        return OfCollectionApiImpl.fromElementModel(Instancio.cast(List.class), elementModel);
    }

    public static <T> InstancioOfCollectionApi<Set<T>> ofSet(Class<T> elementType) {
        return new OfCollectionApiImpl<T, Set>(Set.class, elementType);
    }

    public static <T> InstancioOfCollectionApi<Set<T>> ofSet(Model<T> elementModel) {
        return OfCollectionApiImpl.fromElementModel(Instancio.cast(Set.class), elementModel);
    }

    public static <K, V> InstancioOfCollectionApi<Map<K, V>> ofMap(Class<K> keyType, Class<V> valueType) {
        return new OfMapApiImpl<K, V, Map>(Map.class, keyType, valueType);
    }

    private static <T, C extends Collection<T>> Class<C> cast(Class<?> collectionClass) {
        return collectionClass;
    }
}

