/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.generator.AfterGenerate;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.util.ReflectionUtils;

class FieldNodePopulationFilter
implements NodePopulationFilter {
    private final ModelContext<?> context;

    FieldNodePopulationFilter(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public boolean shouldSkip(Node fieldNode, AfterGenerate afterGenerate, Object objectContainingField) {
        if (afterGenerate == AfterGenerate.DO_NOT_MODIFY) {
            return true;
        }
        if (this.context.getGenerator(fieldNode).isPresent()) {
            return false;
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS) {
            return ReflectionUtils.hasNonNullValue(fieldNode.getField(), objectContainingField);
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            return ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(fieldNode.getField(), objectContainingField);
        }
        return afterGenerate != AfterGenerate.POPULATE_ALL;
    }
}

