/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.instancio.generator.Generator;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.EnumGeneratorSpec;
import org.instancio.generator.specs.EnumSetGeneratorSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.util.TypeUtils;

final class GeneratorSupport {
    private GeneratorSupport() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean supports(Generator<?> generator, Class<?> type) {
        if (generator instanceof ArrayGeneratorSpec) {
            return type.isArray();
        }
        if (generator instanceof EnumSetGeneratorSpec) {
            return EnumSet.class.isAssignableFrom(type);
        }
        if (generator instanceof CollectionGeneratorSpec) {
            if (Collection.class.isAssignableFrom(type)) return true;
            if (type != Iterable.class) return false;
            return true;
        }
        if (generator instanceof MapGeneratorSpec) {
            return Map.class.isAssignableFrom(type);
        }
        if (generator instanceof EnumGeneratorSpec) {
            return type.isEnum();
        }
        Class<?> typeArg = TypeUtils.getGenericSuperclassTypeArgument(generator.getClass());
        if (typeArg == null) return false;
        if (typeArg.isAssignableFrom(type)) return true;
        if (!PrimitiveWrapperBiLookup.findEquivalent(typeArg).filter(type::isAssignableFrom).isPresent()) return false;
        return true;
    }

    static AbstractGenerator<?> unpackGenerator(Generator<?> generator) {
        Generator<?> delegate;
        if (generator instanceof AbstractGenerator) {
            return (AbstractGenerator)generator;
        }
        if (generator instanceof GeneratorDecorator && (delegate = ((GeneratorDecorator)generator).getDelegate()) instanceof AbstractGenerator) {
            return (AbstractGenerator)delegate;
        }
        return null;
    }
}

