/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.Model;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeFactory;

final class InternalModel<T>
implements Model<T> {
    private final ModelContext<T> modelContext;
    private final Node rootNode;

    InternalModel(ModelContext<T> modelContext) {
        this.modelContext = modelContext;
        this.rootNode = this.createRootNode();
    }

    ModelContext<T> getModelContext() {
        return this.modelContext;
    }

    Node getRootNode() {
        return this.rootNode;
    }

    private Node createRootNode() {
        NodeContext nodeContext = NodeContext.builder().rootTypeMap(this.modelContext.getRootTypeMap()).subtypeSelectorMap(this.modelContext.getSubtypeSelectorMap()).subtypeMappingFromSettings(this.modelContext.getSettings().getSubtypeMap()).containerFactories(this.modelContext.getContainerFactories()).build();
        NodeFactory nodeFactory = new NodeFactory(nodeContext);
        return nodeFactory.createRootNode(this.modelContext.getRootType());
    }

    public String toString() {
        return String.format("Model<%s>", this.rootNode.getType().getTypeName());
    }
}

