/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.selectors.Flattener;

class BooleanSelectorMap {
    private final Set<TargetSelector> targetSelectors;
    private final SelectorMap<Boolean> selectorMap = new SelectorMap();

    BooleanSelectorMap(Set<TargetSelector> targetSelectors) {
        this.targetSelectors = Collections.unmodifiableSet(targetSelectors);
        this.putAll(targetSelectors);
    }

    public SelectorMap<Boolean> getSelectorMap() {
        return this.selectorMap;
    }

    Set<TargetSelector> getTargetSelectors() {
        return this.targetSelectors;
    }

    boolean isTrue(Node node) {
        return Boolean.TRUE.equals(this.selectorMap.getValue(node).orElse(false));
    }

    private void putAll(Set<TargetSelector> targetSelectors) {
        for (TargetSelector targetSelector : targetSelectors) {
            for (TargetSelector target : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(target, true);
            }
        }
    }
}

