/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.instancio.GeneratorSpecProvider;
import org.instancio.Mode;
import org.instancio.OnCompleteCallback;
import org.instancio.Random;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.ThreadLocalSettings;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.GeneratorSelectorMap;
import org.instancio.internal.context.Global;
import org.instancio.internal.context.InternalContainerFactoryProviderImpl;
import org.instancio.internal.context.ModelContextHelper;
import org.instancio.internal.context.OnCompleteCallbackSelectorMap;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.context.UnusedSelectorReporter;
import org.instancio.internal.generator.misc.SupplierAdapter;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.spi.InternalContainerFactoryProvider;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public final class ModelContext<T> {
    private static final List<InternalContainerFactoryProvider> CONTAINER_FACTORIES = CollectionUtils.combine(ServiceLoaders.loadAll(InternalContainerFactoryProvider.class), new InternalContainerFactoryProviderImpl());
    private final Type rootType;
    private final List<Class<?>> rootTypeParameters;
    private final Map<TypeVariable<?>, Class<?>> rootTypeMap;
    private final Long seed;
    private final Random random;
    private final Settings settings;
    private final BooleanSelectorMap ignoredSelectorMap;
    private final BooleanSelectorMap nullableSelectorMap;
    private final OnCompleteCallbackSelectorMap onCompleteCallbackSelectorMap;
    private final SubtypeSelectorMap subtypeSelectorMap;
    private final GeneratorSelectorMap generatorSelectorMap;

    private ModelContext(Builder<T> builder) {
        this.rootType = ((Builder)builder).rootType;
        this.rootTypeParameters = Collections.unmodifiableList(((Builder)builder).rootTypeParameters);
        this.rootTypeMap = this.rootType instanceof ParameterizedType || this.rootType instanceof GenericArrayType ? Collections.emptyMap() : Collections.unmodifiableMap(ModelContextHelper.buildRootTypeMap(((Builder)builder).rootType, ((Builder)builder).rootTypeParameters));
        this.seed = ((Builder)builder).seed;
        this.settings = ModelContext.createSettings(builder);
        this.random = RandomHelper.resolveRandom((Long)this.settings.get(Keys.SEED), ((Builder)builder).seed);
        this.ignoredSelectorMap = new BooleanSelectorMap(((Builder)builder).ignoredTargets);
        this.nullableSelectorMap = new BooleanSelectorMap(((Builder)builder).nullableTargets);
        this.onCompleteCallbackSelectorMap = new OnCompleteCallbackSelectorMap(((Builder)builder).onCompleteCallbacks);
        this.subtypeSelectorMap = new SubtypeSelectorMap(((Builder)builder).subtypeSelectors);
        this.generatorSelectorMap = new GeneratorSelectorMap(new GeneratorContext(this.settings, this.random), ((Builder)builder).generatorSelectors, ((Builder)builder).generatorSpecSelectors);
        this.subtypeSelectorMap.putAll(this.generatorSelectorMap.getGeneratorSubtypeMap());
    }

    private static Settings createSettings(Builder<?> builder) {
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(((Builder)builder).settings);
        if (Boolean.TRUE.equals(((Builder)builder).lenient)) {
            settings.set(Keys.MODE, (Object)Mode.LENIENT);
        }
        return settings.lock();
    }

    public List<InternalContainerFactoryProvider> getContainerFactories() {
        return CONTAINER_FACTORIES;
    }

    public void reportUnusedSelectorWarnings() {
        if (this.settings.get(Keys.MODE) == Mode.STRICT) {
            UnusedSelectorReporter reporter = UnusedSelectorReporter.builder().ignored(this.ignoredSelectorMap.getSelectorMap().getUnusedKeys()).nullable(this.nullableSelectorMap.getSelectorMap().getUnusedKeys()).generators(this.generatorSelectorMap.getSelectorMap().getUnusedKeys()).callbacks(this.onCompleteCallbackSelectorMap.getSelectorMap().getUnusedKeys()).subtypes(this.subtypeSelectorMap.getSelectorMap().getUnusedKeys()).build();
            reporter.report();
        }
    }

    public Type getRootType() {
        return this.rootType;
    }

    public boolean isIgnored(Node node) {
        return this.ignoredSelectorMap.isTrue(node);
    }

    public boolean isNullable(Node node) {
        return this.nullableSelectorMap.isTrue(node);
    }

    public Optional<Generator<?>> getGenerator(Node node) {
        return this.generatorSelectorMap.getGenerator(node);
    }

    public List<OnCompleteCallback<?>> getCallbacks(Node node) {
        return this.onCompleteCallbackSelectorMap.getCallbacks(node);
    }

    public SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.subtypeSelectorMap;
    }

    public Map<TypeVariable<?>, Class<?>> getRootTypeMap() {
        return this.rootTypeMap;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder(this.rootType);
        builder.rootTypeParameters.addAll(this.rootTypeParameters);
        builder.seed = this.seed;
        builder.settings = this.settings;
        builder.nullableTargets.addAll(this.nullableSelectorMap.getTargetSelectors());
        builder.ignoredTargets.addAll(this.ignoredSelectorMap.getTargetSelectors());
        builder.generatorSelectors.putAll(this.generatorSelectorMap.getGeneratorSelectors());
        builder.generatorSpecSelectors.putAll(this.generatorSelectorMap.getGeneratorSpecSelectors());
        builder.subtypeSelectors.putAll(this.subtypeSelectorMap.getSubtypeSelectors());
        builder.onCompleteCallbacks.putAll(this.onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
        return builder;
    }

    public static <T> Builder<T> builder(Type rootType) {
        return new Builder(rootType);
    }

    public static final class Builder<T> {
        private final Type rootType;
        private final Class<T> rootClass;
        private final List<Class<?>> rootTypeParameters = new ArrayList();
        private final Map<TargetSelector, Class<?>> subtypeSelectors = new LinkedHashMap();
        private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors = new LinkedHashMap();
        private final Map<TargetSelector, Generator<?>> generatorSelectors = new LinkedHashMap();
        private final Map<TargetSelector, OnCompleteCallback<?>> onCompleteCallbacks = new LinkedHashMap();
        private final Set<TargetSelector> ignoredTargets = new LinkedHashSet<TargetSelector>();
        private final Set<TargetSelector> nullableTargets = new LinkedHashSet<TargetSelector>();
        private Settings settings;
        private Long seed;
        private Boolean lenient;

        private Builder(Type rootType) {
            this.rootType = Verify.notNull(rootType, "Root type is null", new Object[0]);
            this.rootClass = TypeUtils.getRawType(this.rootType);
        }

        public Builder<T> withRootTypeParameters(List<Class<?>> rootTypeParameters) {
            ApiValidator.validateTypeParameters(this.rootClass, rootTypeParameters);
            this.rootTypeParameters.addAll(rootTypeParameters);
            return this;
        }

        public Builder<T> withSubtype(TargetSelector selector, Class<?> subtype) {
            this.subtypeSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), ApiValidator.notNull(subtype, "Subtype must not be null", new Object[0]));
            return this;
        }

        public Builder<T> withGenerator(TargetSelector selector, Generator<?> generator) {
            this.generatorSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), generator);
            return this;
        }

        public Builder<T> withSupplier(TargetSelector selector, Supplier<?> supplier) {
            this.generatorSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), new SupplierAdapter(supplier));
            return this;
        }

        public <V> Builder<T> withGeneratorSpec(TargetSelector selector, GeneratorSpecProvider<V> spec) {
            this.generatorSpecSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), spec);
            return this;
        }

        public Builder<T> withOnCompleteCallback(TargetSelector selector, OnCompleteCallback<?> callback) {
            this.onCompleteCallbacks.put(ModelContextHelper.preProcess(selector, this.rootClass), callback);
            return this;
        }

        public Builder<T> withIgnored(TargetSelector selector) {
            this.ignoredTargets.add(ModelContextHelper.preProcess(selector, this.rootClass));
            return this;
        }

        public Builder<T> withNullable(TargetSelector selector) {
            this.nullableTargets.add(ModelContextHelper.preProcess(selector, this.rootClass));
            return this;
        }

        public Builder<T> withSettings(Settings arg) {
            ApiValidator.notNull(arg, "Null Settings provided to withSettings() method", new Object[0]);
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public Builder<T> withSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder<T> lenient() {
            this.lenient = true;
            return this;
        }

        public Builder<T> useModelAsTypeArgument(ModelContext<?> otherContext) {
            this.rootTypeParameters.add(TypeUtils.getRawType(otherContext.getRootType()));
            this.seed = ((ModelContext)otherContext).seed;
            this.settings = ((ModelContext)otherContext).settings;
            this.nullableTargets.addAll(((ModelContext)otherContext).nullableSelectorMap.getTargetSelectors());
            this.ignoredTargets.addAll(((ModelContext)otherContext).ignoredSelectorMap.getTargetSelectors());
            this.generatorSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSelectors());
            this.generatorSpecSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSpecSelectors());
            this.subtypeSelectors.putAll(((ModelContext)otherContext).subtypeSelectorMap.getSubtypeSelectors());
            this.onCompleteCallbacks.putAll(((ModelContext)otherContext).onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
            return this;
        }

        public ModelContext<T> build() {
            return new ModelContext(this);
        }
    }
}

