/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.GetMethodSelector;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.Selector;
import org.instancio.TargetSelector;
import org.instancio.exception.InstancioException;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.MetamodelSelector;
import org.instancio.internal.selectors.MethodReferenceHelper;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.selectors.SelectorGroupImpl;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContextHelper.class);

    static TargetSelector preProcess(TargetSelector selector, Class<?> rootClass) {
        Verify.notNull(selector, "Selector must not be null", new Object[0]);
        if (selector instanceof MetamodelSelector) {
            return ((MetamodelSelector)selector).copyWithNewStackTraceHolder();
        }
        if (selector instanceof SelectorGroupImpl) {
            List<TargetSelector> results = ModelContextHelper.flattenSelectorGroup((SelectorGroupImpl)selector, rootClass);
            return new SelectorGroupImpl(results.toArray(new GroupableSelector[0]));
        }
        if (selector instanceof GetMethodSelector) {
            return MethodReferenceHelper.resolve((GetMethodSelector)selector);
        }
        if (selector instanceof SelectorImpl) {
            return ModelContextHelper.applyRootClass((SelectorImpl)selector, rootClass);
        }
        if (selector instanceof PrimitiveAndWrapperSelectorImpl) {
            PrimitiveAndWrapperSelectorImpl ps = (PrimitiveAndWrapperSelectorImpl)selector;
            if (ps.isScoped()) {
                List<Scope> scopes = ModelContextHelper.recreateWithRootClass(rootClass, ps.getPrimitive().getScopes());
                return new PrimitiveAndWrapperSelectorImpl(SelectorImpl.builder(ps.getPrimitive()).scopes(scopes).build(), SelectorImpl.builder(ps.getWrapper()).scopes(scopes).build());
            }
            return selector;
        }
        if (selector instanceof PredicateSelectorImpl) {
            return selector;
        }
        if (selector instanceof SelectorBuilder) {
            return ((SelectorBuilder)((Object)selector)).build();
        }
        throw new InstancioException("Unhandled selector type: " + selector.getClass());
    }

    private static SelectorImpl applyRootClass(SelectorImpl source, Class<?> rootClass) {
        if (source.getTargetClass() == null) {
            return SelectorImpl.builder(source).targetClass(rootClass).scopes(ModelContextHelper.recreateWithRootClass(rootClass, source.getScopes())).build();
        }
        if (!source.getScopes().isEmpty()) {
            return SelectorImpl.builder(source).scopes(ModelContextHelper.recreateWithRootClass(rootClass, source.getScopes())).build();
        }
        return source;
    }

    private static List<Scope> recreateWithRootClass(Class<?> rootClass, List<Scope> scopes) {
        ArrayList<Scope> results = new ArrayList<Scope>(scopes.size());
        for (Scope scope : scopes) {
            ScopeImpl s = (ScopeImpl)scope;
            if (s.getTargetClass() == null) {
                results.add(new ScopeImpl(rootClass, s.getFieldName()));
                continue;
            }
            results.add(scope);
        }
        return results;
    }

    private static List<TargetSelector> flattenSelectorGroup(SelectorGroupImpl selectorGroup, Class<?> rootClass) {
        ArrayList<TargetSelector> results = new ArrayList<TargetSelector>();
        for (Selector groupMember : selectorGroup.getSelectors()) {
            if (groupMember instanceof MetamodelSelector) {
                results.add(((MetamodelSelector)groupMember).copyWithNewStackTraceHolder());
                continue;
            }
            if (groupMember instanceof SelectorImpl) {
                SelectorImpl selector = ModelContextHelper.applyRootClass((SelectorImpl)groupMember, rootClass);
                results.add(selector);
                continue;
            }
            if (groupMember instanceof PrimitiveAndWrapperSelectorImpl) {
                results.addAll(((PrimitiveAndWrapperSelectorImpl)groupMember).flatten());
                continue;
            }
            throw new InstancioException("Unhandled selector type: " + groupMember.getClass());
        }
        return results;
    }

    static Map<TypeVariable<?>, Class<?>> buildRootTypeMap(Type rootType, List<Class<?>> rootTypeParameters) {
        Class rootClass = TypeUtils.getRawType(rootType);
        ApiValidator.validateTypeParameters(rootClass, rootTypeParameters);
        Class<Object> targetClass = rootClass.isArray() ? rootClass.getComponentType() : rootClass;
        TypeVariable<Class<Object>>[] typeVariables = targetClass.getTypeParameters();
        HashMap typeMap = new HashMap();
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable<Class<Object>> typeVariable = typeVariables[i];
            Class<?> actualType = rootTypeParameters.get(i);
            LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, actualType);
            typeMap.put(typeVariable, actualType);
        }
        ModelContextHelper.populateTypeMapFromGenericSuperclass(rootClass, typeMap);
        return typeMap;
    }

    private static void populateTypeMapFromGenericSuperclass(@Nullable Class<?> rootClass, Map<TypeVariable<?>, Class<?>> typeMap) {
        if (rootClass == null) {
            return;
        }
        Type gsClass = rootClass.getGenericSuperclass();
        if (gsClass instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)gsClass;
            Class rawType = TypeUtils.getRawType(genericSuperclass.getRawType());
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (actualTypeArguments[i] instanceof TypeVariable) continue;
                TypeVariable typeVariable = typeParameters[i];
                Class actualType = TypeUtils.getRawType(actualTypeArguments[i]);
                LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, actualType);
                typeMap.put(typeVariable, actualType);
            }
        }
        if (gsClass != null) {
            ModelContextHelper.populateTypeMapFromGenericSuperclass(TypeUtils.getRawType(gsClass), typeMap);
        }
    }

    private ModelContextHelper() {
    }
}

