/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.instancio.OnCompleteCallback;
import org.instancio.TargetSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.selectors.Flattener;

class OnCompleteCallbackSelectorMap {
    private final Map<TargetSelector, OnCompleteCallback<?>> onCompleteCallbacks;
    private final SelectorMap<OnCompleteCallback<?>> selectorMap = new SelectorMap();

    OnCompleteCallbackSelectorMap(Map<TargetSelector, OnCompleteCallback<?>> callbacks) {
        this.onCompleteCallbacks = Collections.unmodifiableMap(callbacks);
        this.putAll(callbacks);
    }

    public SelectorMap<OnCompleteCallback<?>> getSelectorMap() {
        return this.selectorMap;
    }

    public Map<TargetSelector, OnCompleteCallback<?>> getOnCompleteCallbackSelectors() {
        return this.onCompleteCallbacks;
    }

    List<OnCompleteCallback<?>> getCallbacks(Node node) {
        return this.selectorMap.getValues(node);
    }

    private void putAll(Map<TargetSelector, OnCompleteCallback<?>> callbacks) {
        for (Map.Entry<TargetSelector, OnCompleteCallback<?>> entry : callbacks.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            OnCompleteCallback<?> callback = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(selector, callback);
            }
        }
    }
}

